/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.core.collections;

import io.restassured.http.Method;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.locationtech.jts.io.ParseException;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.conformance.core.collections.AbstractFeatures;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class Features
extends AbstractFeatures {
    @DataProvider(name="collectionItemUris")
    public Iterator<Object[]> collectionItemUris(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map collection : this.collections) {
            collectionsData.add(new Object[]{collection});
        }
        return collectionsData.iterator();
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Abstract Test 13 (Requirement /req/core/fc-op)", groups={"featuresBase"}, dataProvider="collectionItemUris", dependsOnGroups={"collections"}, alwaysRun=true)
    public void validateFeaturesOperation(ITestContext testContext, Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        String featuresUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuresUrl == null) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        ZonedDateTime timeStampBeforeResponse = ZonedDateTime.now();
        Response response = (Response)this.init().baseUri(featuresUrl).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        ZonedDateTime timeStampAfterResponse = ZonedDateTime.now();
        AbstractFeatures.ResponseData responseData = new AbstractFeatures.ResponseData(this, response, timeStampBeforeResponse, timeStampAfterResponse);
        this.collectionIdAndResponse.put(this.asKey(collectionId), responseData);
        this.addFeatureIdToTestContext(testContext, collectionId, response);
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Abstract Test 2, Test Method 2 (Requirement /req/core/crs84)", dataProvider="collectionItemUris", dependsOnMethods={"validateFeaturesOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_GeometryInCRS84(Map<String, Object> collection) throws ParseException {
        String collectionId = (String)collection.get("id");
        this.validateGeometriesInCrs84(this.asKey(collectionId));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Abstract Test 22, Test Method 1 (Requirement /req/core/fc-response)", dataProvider="collectionItemUris", dependsOnMethods={"validateFeaturesOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_TypeProperty(Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        this.validateTypeProperty(this.asKey(collectionId));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Abstract Test 22, Test Method 2 (Requirement /req/core/fc-response)", dataProvider="collectionItemUris", dependsOnMethods={"validateFeaturesOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_FeaturesProperty(Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        this.validateFeaturesProperty(this.asKey(collectionId));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Abstract Test 22, Test Method 4 (Requirement /req/core/fc-response) - Abstract Test 23 (Requirement /req/core/fc-links, /req/core/fc-rel-type)", dataProvider="collectionItemUris", dependsOnMethods={"validateFeaturesOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_Links(Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        this.validateLinks(this.asKey(collectionId));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Abstract Test 22, Test Method 5 (Requirement /req/core/fc-response) - Abstract Test 24 (Requirement /req/core/fc-timeStamp)", dataProvider="collectionItemUris", dependsOnMethods={"validateFeaturesOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_TimeStamp(Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        this.validateTimeStamp(this.asKey(collectionId));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Abstract Test 22, Test Method 6 (Requirement /req/core/fc-response) - Abstract Test 25 (Requirement /req/core/fc-numberMatched)", dataProvider="collectionItemUris", dependsOnMethods={"validateFeaturesOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_NumberMatched(Map<String, Object> collection) throws URISyntaxException {
        String collectionId = (String)collection.get("id");
        this.validateNumberMatched(this.asKey(collectionId));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Abstract Test 22, Test Method 7 (Requirement /req/core/fc-response) - Abstract Test 26 (Requirement /req/core/fc-numberReturned)", dataProvider="collectionItemUris", dependsOnMethods={"validateFeaturesOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_NumberReturned(Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        this.validateNumberReturned(this.asKey(collectionId));
    }

    private void addFeatureIdToTestContext(ITestContext testContext, String collectionName, Response response) {
        String featureId;
        if (response == null) {
            return;
        }
        HashMap<String, String> collectionNameAndFeatureId = (HashMap<String, String>)testContext.getSuite().getAttribute(SuiteAttribute.FEATUREIDS.getName());
        if (collectionNameAndFeatureId == null) {
            collectionNameAndFeatureId = new HashMap<String, String>();
            testContext.getSuite().setAttribute(SuiteAttribute.FEATUREIDS.getName(), collectionNameAndFeatureId);
        }
        if ((featureId = JsonUtils.parseFeatureId(response.jsonPath())) != null) {
            collectionNameAndFeatureId.put(collectionName, featureId);
        }
    }

    private AbstractFeatures.CollectionResponseKey asKey(String collectionId) {
        return new AbstractFeatures.CollectionResponseKey(this, collectionId);
    }
}

