/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay.parser;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.reprezen.jsonoverlay.PositionInfo;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class LocationProcessor {
    private final Map<JsonPointer, PositionInfo> locations = new HashMap<JsonPointer, PositionInfo>();
    private Deque<Context> contextStack = new ArrayDeque<Context>();
    private Context context = new RootContext();

    LocationProcessor() {
    }

    public Map<JsonPointer, PositionInfo> getLocations() {
        return Collections.unmodifiableMap(this.locations);
    }

    public void processTokenLocation(JsonToken token, String name, JsonLocation tokenStart, JsonLocation tokenEnd) {
        switch (token) {
            case FIELD_NAME: {
                this.context.setNextProp(name);
                break;
            }
            case START_OBJECT: {
                this.context.startValue();
                this.contextStack.push(this.context);
                this.context = new ObjectContext(this.context, tokenStart);
                break;
            }
            case END_OBJECT: {
                this.recordInfo(this.context, tokenEnd);
                if (!(this.context instanceof ObjectContext)) {
                    throw new IllegalStateException();
                }
                this.context = this.contextStack.pop();
                break;
            }
            case START_ARRAY: {
                this.context.startValue();
                this.contextStack.push(this.context);
                this.context = new ArrayContext(this.context, tokenStart);
                break;
            }
            case END_ARRAY: {
                this.recordInfo(this.context, tokenEnd);
                if (!(this.context instanceof ArrayContext)) {
                    throw new IllegalStateException();
                }
                this.context = this.contextStack.pop();
                break;
            }
            case NOT_AVAILABLE: 
            case VALUE_EMBEDDED_OBJECT: {
                throw new IllegalStateException();
            }
            default: {
                this.context.startValue();
                this.recordInfo(this.context.getChildPointer(), tokenStart, tokenEnd);
            }
        }
    }

    private void recordInfo(Context context, JsonLocation end) {
        this.recordInfo(context.getPointer(), context.getStart(), end);
    }

    private void recordInfo(JsonPointer ptr, JsonLocation start, JsonLocation end) {
        PositionInfo pos = new PositionInfo(ptr, start, end);
        this.locations.put(ptr, pos);
    }

    private static class ArrayContext
    extends Context {
        private int currentIndex = -1;

        public ArrayContext(Context parent, JsonLocation start) {
            super(parent.getChildPointer(), start, null);
        }

        @Override
        public JsonPointer getChildPointer() {
            if (this.currentIndex >= 0) {
                return this.ptr.append(JsonPointer.compile((String)("/" + this.currentIndex)));
            }
            throw new IllegalStateException();
        }

        @Override
        public void startValue() {
            ++this.currentIndex;
        }

        @Override
        public void setNextProp(String name) {
            throw new IllegalStateException();
        }
    }

    private static class ObjectContext
    extends Context {
        private String currentProp = null;
        private String nextProp = null;

        public ObjectContext(Context parent, JsonLocation start) {
            super(parent.getChildPointer(), start, null);
        }

        @Override
        public JsonPointer getChildPointer() {
            if (this.currentProp != null) {
                JsonPointer child = JsonPointer.compile((String)("/" + this.encode(this.currentProp)));
                return this.ptr.append(child);
            }
            throw new IllegalStateException();
        }

        private String encode(String s) {
            return s.replaceAll("~", "~0").replaceAll("/", "~1");
        }

        @Override
        public void startValue() {
            if (this.nextProp == null) {
                throw new IllegalStateException();
            }
            this.currentProp = this.nextProp;
            this.nextProp = null;
        }

        @Override
        public void setNextProp(String name) {
            if (this.nextProp != null) {
                throw new IllegalStateException();
            }
            this.nextProp = name;
        }
    }

    private static class RootContext
    extends Context {
        public RootContext() {
            super(JsonPointer.compile((String)""), null, null);
        }

        @Override
        public JsonPointer getChildPointer() {
            return this.ptr;
        }

        @Override
        public void startValue() {
        }

        @Override
        public void setNextProp(String name) {
            throw new IllegalStateException();
        }
    }

    private static abstract class Context {
        protected JsonPointer ptr;
        protected JsonLocation start;
        protected JsonLocation end;

        public Context(JsonPointer ptr, JsonLocation start, JsonLocation end) {
            this.ptr = ptr;
            this.start = start;
            this.end = end;
        }

        public JsonPointer getPointer() {
            return this.ptr;
        }

        public JsonLocation getStart() {
            return this.start;
        }

        public JsonLocation getEnd() {
            return this.end;
        }

        public abstract JsonPointer getChildPointer();

        public abstract void startValue();

        public abstract void setNextProp(String var1);
    }
}

