/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.core.collections;

import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Schema;
import io.restassured.http.Method;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.locationtech.jts.io.ParseException;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.core.collections.AbstractFeatures;
import org.opengis.cite.ogcapifeatures10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.util.BBox;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeaturesBBox
extends AbstractFeatures {
    @DataProvider(name="collectionItemUrisWithBboxes")
    public Iterator<Object[]> collectionItemUrisWithBboxes(ITestContext testContext) {
        ArrayList<Object[]> collectionsWithBboxes = new ArrayList<Object[]>();
        for (Map collection : this.collections) {
            BBox extent = JsonUtils.parseSpatialExtent(collection);
            if (extent == null) continue;
            collectionsWithBboxes.add(new Object[]{collection, extent});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(-1.5, 50.0, 1.5, 53.0)});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(-80.0, -5.0, -70.0, 5.0)});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(177.0, 65.0, -177.0, 70.0)});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(-180.0, 85.0, 180.0, 90.0)});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(-180.0, -90.0, 180.0, -85.0)});
        }
        return collectionsWithBboxes.iterator();
    }

    @Test(description="A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 14: (Requirement /req/core/fc-bbox-definition)", dataProvider="collectionPaths", dependsOnGroups={"featuresBase"}, alwaysRun=true)
    public void boundingBoxParameterDefinition(TestPoint testPoint) {
        Parameter bbox = OpenApiUtils.retrieveParameterByName(testPoint.getPath(), this.getApiModel(), "bbox");
        Assert.assertNotNull((Object)bbox, (String)("Required bbox parameter for collections path '" + testPoint.getPath() + "'  in OpenAPI document is missing"));
        String msg = "Expected property '%s' with value '%s' for collections path '" + testPoint.getPath() + "' but was '%s'.";
        Assert.assertEquals((String)bbox.getName(), (String)"bbox", (String)String.format(msg, "name", "bbox", bbox.getName()));
        Assert.assertEquals((String)bbox.getIn(), (String)"query", (String)String.format(msg, "in", "query", bbox.getIn()));
        EtsAssert.assertFalse(this.isRequired(bbox), String.format(msg, "required", "false", bbox.getRequired()));
        Assert.assertEquals((String)bbox.getStyle(), (String)"form", (String)String.format(msg, "style", "form", bbox.getStyle()));
        EtsAssert.assertFalse(this.isExplode(bbox), String.format(msg, "explode", "false", bbox.getExplode()));
        Schema schema = bbox.getSchema();
        Assert.assertNotNull((Object)schema, (String)("Expected schema for bbox parameter for collections path '" + testPoint.getPath()));
        Assert.assertEquals((String)schema.getType(), (String)"array", (String)String.format(msg, "schema -> type", "array", schema.getType()));
        Assert.assertNotNull((Object)schema.getMinItems(), (String)String.format(msg, "schema -> minItems", "null", schema.getMinItems()));
        Assert.assertEquals((int)schema.getMinItems(), (int)4, (String)String.format(msg, "schema -> minItems", "4", schema.getMinItems()));
        Assert.assertNotNull((Object)schema.getMaxItems(), (String)String.format(msg, "schema -> maxItems", "null", schema.getMaxItems()));
        Assert.assertEquals((int)schema.getMaxItems(), (int)6, (String)String.format(msg, "schema -> maxItems", "6", schema.getMaxItems()));
        String itemsType = schema.getItemsSchema().getType();
        Assert.assertEquals((String)itemsType, (String)"number", (String)String.format(msg, "schema -> items -> type", "number", itemsType));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 13: (Requirement /req/core/fc-op)", dataProvider="collectionItemUrisWithBboxes", dependsOnGroups={"featuresBase"}, alwaysRun=true)
    public void validateFeaturesWithBoundingBoxOperation(Map<String, Object> collection, BBox bbox) {
        String collectionId = (String)collection.get("id");
        String getFeaturesUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (getFeaturesUrl.isEmpty()) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        ZonedDateTime timeStampBeforeResponse = ZonedDateTime.now();
        Response response = (Response)this.init().baseUri(getFeaturesUrl).accept("application/geo+json").param("bbox", new Object[]{bbox.asQueryParameter()}).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        ZonedDateTime timeStampAfterResponse = ZonedDateTime.now();
        AbstractFeatures.ResponseData responseData = new AbstractFeatures.ResponseData(this, response, timeStampBeforeResponse, timeStampAfterResponse);
        this.collectionIdAndResponse.put(this.asKey(collectionId, bbox), responseData);
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 15: (Requirement /req/core/fc-bbox-response)", dataProvider="collectionItemUrisWithBboxes", dependsOnMethods={"validateFeaturesWithBoundingBoxOperation"}, alwaysRun=true)
    public void validateFeaturesWithBoundingBoxResponse(Map<String, Object> collection, BBox bbox) throws ParseException {
        String collectionId = (String)collection.get("id");
        this.validateGeometriesInBBox(this.asKey(collectionId, bbox), bbox);
        this.validateGeometriesInCrs84(this.asKey(collectionId, bbox));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 2, Test Method 2 (Requirement /req/core/crs84)", dataProvider="collectionItemUrisWithBboxes", dependsOnMethods={"validateFeaturesWithBoundingBoxOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_GeometryInCRS84(Map<String, Object> collection, BBox bbox) throws ParseException {
        String collectionId = (String)collection.get("id");
        this.validateGeometriesInCrs84(this.asKey(collectionId, bbox));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 22, Test Method 1 (Requirement /req/core/fc-response)", dataProvider="collectionItemUrisWithBboxes", dependsOnMethods={"validateFeaturesWithBoundingBoxOperation"}, alwaysRun=true)
    public void validateFeaturesWithBoundingBoxResponse_TypeProperty(Map<String, Object> collection, BBox bbox) {
        String collectionId = (String)collection.get("id");
        this.validateTypeProperty(this.asKey(collectionId, bbox));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 22, Test Method 2 (Requirement /req/core/fc-response)", dataProvider="collectionItemUrisWithBboxes", dependsOnMethods={"validateFeaturesWithBoundingBoxOperation"}, alwaysRun=true)
    public void validateFeaturesWithBoundingBoxResponse_FeaturesProperty(Map<String, Object> collection, BBox bbox) {
        String collectionId = (String)collection.get("id");
        this.validateFeaturesProperty(this.asKey(collectionId, bbox));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 22, Test Method 4 (Requirement /req/core/fc-response) - Abstract Test 23 (Requirement /req/core/fc-links, /req/core/fc-rel-type)", dataProvider="collectionItemUrisWithBboxes", dependsOnMethods={"validateFeaturesWithBoundingBoxOperation"}, alwaysRun=true)
    public void validateFeaturesWithBoundingBoxResponse_Links(Map<String, Object> collection, BBox bbox) {
        String collectionId = (String)collection.get("id");
        this.validateLinks(this.asKey(collectionId, bbox));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 22, Test Method 5 (Requirement /req/core/fc-response) - Abstract Test 24 (Requirement /req/core/fc-timeStamp)", dataProvider="collectionItemUrisWithBboxes", dependsOnMethods={"validateFeaturesWithBoundingBoxOperation"}, alwaysRun=true)
    public void validateFeaturesWithBoundingBoxResponse_TimeStamp(Map<String, Object> collection, BBox bbox) {
        String collectionId = (String)collection.get("id");
        this.validateTimeStamp(this.asKey(collectionId, bbox));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 22, Test Method 6 (Requirement /req/core/fc-response) - Abstract Test 25 (Requirement /req/core/fc-numberMatched)", dataProvider="collectionItemUrisWithBboxes", dependsOnMethods={"validateFeaturesWithBoundingBoxOperation"}, alwaysRun=true)
    public void validateFeaturesWithBoundingBoxResponse_NumberMatched(Map<String, Object> collection, BBox bbox) throws URISyntaxException {
        String collectionId = (String)collection.get("id");
        this.validateNumberMatched(this.asKey(collectionId, bbox));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - BoundingBox, Abstract Test 22, Test Method 7 (Requirement /req/core/fc-response) - Abstract Test 26 (Requirement /req/core/fc-numberReturned)", dataProvider="collectionItemUrisWithBboxes", dependsOnMethods={"validateFeaturesWithBoundingBoxOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_NumberReturned(Map<String, Object> collection, BBox bbox) {
        String collectionId = (String)collection.get("id");
        this.validateNumberReturned(this.asKey(collectionId, bbox));
    }

    private CollectionIdWithBboxKey asKey(String collectionId, BBox bBox) {
        return new CollectionIdWithBboxKey(collectionId, bBox);
    }

    private class CollectionIdWithBboxKey
    extends AbstractFeatures.CollectionResponseKey {
        BBox bbox;

        public CollectionIdWithBboxKey(String collectionId, BBox bbox) {
            super(FeaturesBBox.this, collectionId);
            this.bbox = bbox;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollectionIdWithBboxKey that = (CollectionIdWithBboxKey)o;
            return Objects.equals(this.bbox, that.bbox);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.bbox);
        }
    }
}

