/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collections;

import io.restassured.path.json.JsonPath;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collections.AbstractDiscoveryCollections;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.annotations.Test;

public class DiscoveryCollectionsCrsUri
extends AbstractDiscoveryCollections {
    @Test(description="Implements A.1 Discovery, Abstract Test 1 (Requirement /req/crs/crs-uri, /req/crs/fc-md-crs-list A, /req/crs/fc-md-storageCrs, /req/crs/fc-md-crs-list-global), crs property in the collections object in the path /collections", dataProvider="collectionsResponses", dependsOnGroups={"crs-conformance"})
    public void verifyCollectionsCrsIdentifierOfCrsProperty(TestPoint testPoint, JsonPath jsonPath) {
        List<String> crs = JsonUtils.parseAsList("crs", jsonPath);
        for (String crsValue : crs) {
            if (crsValue == null) continue;
            EtsAssert.assertValidCrsIdentifier(new CoordinateSystem(crsValue), String.format("Collections path %s contains invalid CRS identifier property 'crs': '%s'", testPoint.getPath(), crsValue));
        }
    }

    @Test(description="Implements A.1 Discovery, Abstract Test 1 (Requirement /req/crs/crs-uri, /req/crs/fc-md-crs-list A, /req/crs/fc-md-storageCrs, /req/crs/fc-md-crs-list-global), storageCrs property in the collections object in the path /collections", dataProvider="collectionsResponses", dependsOnGroups={"crs-conformance"})
    public void verifyCollectionsCrsIdentifierOfStorageCrs(TestPoint testPoint, JsonPath jsonPath) {
        String crs = JsonUtils.parseAsString(jsonPath.get("storageCrs"));
        if (crs != null) {
            EtsAssert.assertValidCrsIdentifier(new CoordinateSystem(crs), String.format("Collections path %s contains invalid CRS identifier property 'storageCrs': '%s'", testPoint.getPath(), crs));
        }
    }

    @Test(description="Implements A.1 Discovery, Abstract Test 1 (Requirement /req/crs/crs-uri, /req/crs/fc-md-crs-list A, /req/crs/fc-md-storageCrs, /req/crs/fc-md-crs-list-global), crs property in the collection objects in the path /collections", dataProvider="collectionItemUris", dependsOnGroups={"crs-conformance"})
    public void verifyCollectionsCollectionCrsIdentifierOfCrsProperty(TestPoint testPoint, JsonPath jsonPath, Map<String, Object> collection) {
        boolean collectionsHasCrsProperty = this.isCollectionsHasCrsProperty(jsonPath);
        String collectionId = (String)collection.get("id");
        List<String> crs = JsonUtils.parseAsList("crs", collection);
        for (String crsValue : crs) {
            this.isValidCRs(testPoint, collectionsHasCrsProperty, collectionId, crsValue, "crs");
        }
    }

    @Test(description="Implements A.1 Discovery, Abstract Test 1 (Requirement /req/crs/crs-uri, /req/crs/fc-md-crs-list A, /req/crs/fc-md-storageCrs, /req/crs/fc-md-crs-list-global), storageCrs property in the collection objects in the path /collections", dataProvider="collectionItemUris", dependsOnGroups={"crs-conformance"})
    public void verifyCollectionsCollectionCrsIdentifierOfStorageCrs(TestPoint testPoint, JsonPath jsonPath, Map<String, Object> collection) {
        boolean collectionsHasCrsProperty = this.isCollectionsHasCrsProperty(jsonPath);
        String collectionId = (String)collection.get("id");
        List<String> crs = JsonUtils.parseAsList("storageCrs", collection);
        for (String crsValue : crs) {
            this.isValidCRs(testPoint, collectionsHasCrsProperty, collectionId, crsValue, "storageCrs");
        }
    }

    private boolean isCollectionsHasCrsProperty(JsonPath jsonPath) {
        List collectionsCrs = jsonPath.getList("crs");
        return collectionsCrs != null && !collectionsCrs.isEmpty();
    }

    private void isValidCRs(TestPoint testPoint, boolean collectionsHasCrsProperty, String collectionId, String crsValue, String propertyName) {
        if ("#/crs".equals(crsValue) && collectionsHasCrsProperty) {
            return;
        }
        EtsAssert.assertValidCrsIdentifier(new CoordinateSystem(crsValue), String.format("Collection with id '%s' at collections path %s contains invalid CRS identifier property '%s': '%s'", collectionId, testPoint.getPath(), propertyName, crsValue));
    }
}

