/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.bboxcrs;

import io.restassured.path.json.JsonPath;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opengis.cite.ogcapifeatures10.conformance.CommonFixture;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;

public class AbstractBBoxCrs
extends CommonFixture {
    public static final String BBOX_PARAM = "bbox";
    public static final String BBOX_CRS_PARAM = "bbox-crs";
    protected Map<String, JsonPath> collectionsResponses;
    protected Map<String, List<CoordinateSystem>> collectionIdToCrs;
    protected Map<String, CoordinateSystem> collectionIdToDefaultCrs;

    @BeforeClass
    public void retrieveRequiredInformationFromTestContext(ITestContext testContext) {
        this.collectionsResponses = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_BY_ID.getName());
        this.collectionIdToCrs = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_CRS_BY_ID.getName());
        this.collectionIdToDefaultCrs = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_DEFAULT_CRS_BY_ID.getName());
    }

    void assertSameFeatures(JsonPath responseWithBBox, JsonPath responseWithoutBBox) {
        List<String> responseWithBBoxIds = this.parseFeatureIds(responseWithBBox);
        List<String> responseWithoutBBoxIds = this.parseFeatureIds(responseWithoutBBox);
        Assert.assertTrue((boolean)responseWithoutBBoxIds.containsAll(responseWithBBoxIds));
    }

    private List<String> parseFeatureIds(JsonPath responseWithBBox) {
        List features = responseWithBBox.getList("features");
        if (features == null) {
            return Collections.emptyList();
        }
        return features.stream().map(feature -> JsonUtils.parseAsString(feature.get("id"))).collect(Collectors.toList());
    }
}

