/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.feature;

import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.MultiKeyMap;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.feature.AbstractFeatureCrs;
import org.opengis.cite.ogcapifeatures10.util.GeometryTransformer;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeatureCrsParameterTransform
extends AbstractFeatureCrs {
    private MultiKeyMap collectionIdAndFeatureIdToGeometry = new MultiKeyMap();

    @DataProvider(name="collectionFeatureIdCrsAndDefaultCrs")
    public Iterator<Object[]> collectionFeatureIdCrsAndDefaultCrs(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        try {
            for (Map.Entry collection : this.collectionsResponses.entrySet()) {
                String collectionId = (String)collection.getKey();
                String featureId = (String)this.collectionIdToFeatureId.get(collectionId);
                if (featureId == null) continue;
                CoordinateSystem defaultCrs = (CoordinateSystem)this.collectionIdToDefaultCrs.get(collectionId);
                JsonPath json = (JsonPath)collection.getValue();
                for (CoordinateSystem crs : (List)this.collectionIdToCrs.get(collectionId)) {
                    collectionsData.add(new Object[]{collectionId, json, featureId, crs, defaultCrs});
                }
            }
        }
        catch (Exception e) {
            collectionsData.add(new Object[]{null, null, null, null, null});
        }
        return collectionsData.iterator();
    }

    @Test(description="Implements A.2.1 Query, Parameter crs, Abstract Test 7 (Requirement /req/crs/crs-action), Geometries in the path /collections/{collectionId}/items/{featureId}", dataProvider="collectionFeatureId", dependsOnGroups={"crs-conformance"}, priority=1)
    public void verifyFeatureCrsParameterTransformWithCrsParameter(String collectionId, JsonPath collection, String featureId) throws ParseException {
        if (collectionId == null & collection == null & featureId == null) {
            throw new AssertionError((Object)"No crs information for collection available.");
        }
        String featureUrl = JsonUtils.findFeatureUrlForGeoJson(this.rootUri, collection, featureId);
        if (featureUrl == null) {
            throw new SkipException(String.format("Could not find url for collection with id %s supporting GeoJson (type %s)", collectionId, "application/geo+json"));
        }
        Response response = (Response)this.init().baseUri(featureUrl).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        String crsHeader = response.getHeader("Content-Crs");
        if (crsHeader == null) {
            throw new AssertionError((Object)String.format("Feature response at '%s' does not provide the expected header 'Content-Crs'", featureUrl));
        }
        EtsAssert.assertDefaultCrs(crsHeader, String.format("Feature response at '%s' does not provide default 'Content-Crs' header, was: '%s', expected: '%s' or '%s'", featureUrl, crsHeader, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/OGC/0/CRS84h"));
        String crs = crsHeader.substring(1, crsHeader.length() - 1);
        Map feature = (Map)response.jsonPath().get();
        Geometry geometry = JsonUtils.parseFeatureGeometry(feature, new CoordinateSystem(crs));
        this.collectionIdAndFeatureIdToGeometry.put((Object)collectionId, (Object)featureId, (Object)geometry);
    }

    @Test(description="Implements A.2.1 Query, Parameter crs, Abstract Test 7 (Requirement /req/crs/crs-action), Transformed geometries in the path /collections/{collectionId}/items/{featureId}", dataProvider="collectionFeatureIdCrsAndDefaultCrs", dependsOnGroups={"crs-conformance"}, dependsOnMethods={"verifyFeatureCrsParameterTransformWithCrsParameter"}, priority=1)
    public void verifyFeatureCrsParameterTransformWithoutCrsParameter(String collectionId, JsonPath collection, String featureId, CoordinateSystem crs, CoordinateSystem defaultCRS) throws ParseException {
        String featureUrl;
        if (collectionId == null & collection == null & featureId == null & crs == null & defaultCRS == null) {
            throw new AssertionError((Object)"No crs information for collection available.");
        }
        if (defaultCRS == null) {
            defaultCRS = new CoordinateSystem("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
        }
        if ((featureUrl = JsonUtils.findFeatureUrlForGeoJson(this.rootUri, collection, featureId)) == null) {
            throw new SkipException(String.format("Could not find url for collection with id %s supporting GeoJson (type %s)", collectionId, "application/geo+json"));
        }
        Response response = (Response)this.init().baseUri(featureUrl).queryParam("crs", new Object[]{crs.getCode()}).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        Map feature = (Map)response.jsonPath().get();
        Geometry geometry = JsonUtils.parseFeatureGeometry(feature, crs);
        Geometry geometryInDefaultCrs = (Geometry)this.collectionIdAndFeatureIdToGeometry.get((Object)collectionId, (Object)featureId);
        GeometryTransformer geometryTransformer = new GeometryTransformer(crs, defaultCRS);
        Geometry transformedGeometry = geometryTransformer.transform(geometry);
        geometryInDefaultCrs.equalsExact(transformedGeometry, 0.001);
    }
}

