/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.features;

import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.features.AbstractFeaturesCrs;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class FeaturesCrsParameter
extends AbstractFeaturesCrs {
    @Test(description="Implements A.2.1 Query, Parameter crs, Abstract Test 4 (Requirement /req/crs/fc-crs-definition, /req/crs/fc-crs-valid-value B, /req/crs/ogc-crs-header, /req/crs/ogc-crs-header-value, /req/crs/geojson), Content-Crs header in the path /collections/{collectionId}/items", dataProvider="collectionIdAndJsonAndCrs", dependsOnGroups={"crs-conformance"}, priority=1)
    public void verifyFeaturesCrsParameter(String collectionId, JsonPath collection, CoordinateSystem crs) {
        if (collectionId == null & collection == null & crs == null) {
            throw new AssertionError((Object)"No crs information for collection available.");
        }
        String featuresUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuresUrl == null) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        Response response = (Response)this.init().baseUri(featuresUrl).queryParam("crs", new Object[]{crs.getCode()}).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        String actualHeader = response.getHeader("Content-Crs");
        if (actualHeader == null) {
            throw new AssertionError((Object)String.format("Features response at '%s' does not provide the expected header 'Content-Crs'", featuresUrl));
        }
        EtsAssert.assertCrsHeader(actualHeader, crs, String.format("Features response at '%s' does not provide expected 'Content-Crs' header, was: '%s', expected: '<%s>'", featuresUrl, actualHeader, crs));
    }
}

