/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import org.opengis.cite.ogcapifeatures10.OgcApiFeatures10;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;

public class BBox {
    private static final String PATTERN = "###.0000000";
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;
    private final CoordinateSystem crs;

    public BBox(double minX, double minY, double maxX, double maxY) {
        this(minX, minY, maxX, maxY, OgcApiFeatures10.DEFAULT_CRS);
    }

    public BBox(double minX, double minY, double maxX, double maxY, CoordinateSystem crs) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.crs = crs;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public CoordinateSystem getCrs() {
        return this.crs;
    }

    public String asQueryParameter() {
        StringBuilder sb = new StringBuilder();
        DecimalFormat formatter = this.formatter();
        sb.append(formatter.format(this.minX)).append(",");
        sb.append(formatter.format(this.minY)).append(",");
        sb.append(formatter.format(this.maxX)).append(",");
        sb.append(formatter.format(this.maxY));
        return sb.toString();
    }

    public String toString() {
        return this.asQueryParameter();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBox bBox = (BBox)o;
        return Double.compare(bBox.minX, this.minX) == 0 && Double.compare(bBox.minY, this.minY) == 0 && Double.compare(bBox.maxX, this.maxX) == 0 && Double.compare(bBox.maxY, this.maxY) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.maxX, this.maxY);
    }

    private DecimalFormat formatter() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(PATTERN);
        return df;
    }
}

