/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.ReferenceManager;
import com.reprezen.jsonoverlay.ReferenceRegistry;

public class RefOverlay<V> {
    private Reference reference;
    private JsonOverlay<?> parent;
    private JsonOverlay<V> target = null;
    private OverlayFactory<V> factory;
    private ReferenceManager refMgr;

    public RefOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<V> factory, ReferenceManager refMgr) {
        this.reference = refMgr.getReference(json);
        this.parent = parent;
        this.factory = factory;
        this.refMgr = refMgr;
    }

    public RefOverlay(Reference reference, JsonOverlay<?> parent, OverlayFactory<V> factory, ReferenceManager refMgr) {
        this.reference = reference;
        this.parent = parent;
        this.factory = factory;
        this.refMgr = refMgr;
    }

    JsonOverlay<V> getOverlay() {
        if (!this.reference.isResolved()) {
            this.reference.resolve();
        }
        if (this.target == null && this.reference.isValid()) {
            ReferenceRegistry registry = this.refMgr.getRegistry();
            JsonOverlay<?> castTarget = registry.getOverlay(this.reference.getNormalizedRef(), this.factory.getSignature());
            this.target = castTarget;
            if (this.target == null) {
                castTarget = registry.getOverlay(this.reference.getJson(), this.factory.getSignature());
                this.target = castTarget;
            }
            if (this.target == null) {
                this.target = this.factory.create(this.reference.getJson(), (JsonOverlay<?>)null, this.reference.getManager());
                this.target._setCreatingRef(this.reference);
                this.refMgr.getRegistry().register(this.reference.getNormalizedRef(), this.factory.getSignature(), this.target);
            }
        }
        return this.target;
    }

    public V _get(boolean elaborate) {
        this.getOverlay();
        return this.target != null ? (V)this.target._get(elaborate) : null;
    }

    public Reference _getReference() {
        return this.reference;
    }

    public JsonOverlay<?> _getParent() {
        return this.parent;
    }
}

