/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.bboxcrs;

import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.bboxcrs.AbstractBBoxCrs;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.util.BBox;
import org.opengis.cite.ogcapifeatures10.util.GeometryTransformer;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BBoxCrsParameterDefault
extends AbstractBBoxCrs {
    @DataProvider(name="collectionDefaultCrs")
    public Iterator<Object[]> collectionDefaultCrs(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map.Entry collection : this.collectionsResponses.entrySet()) {
            String collectionId = (String)collection.getKey();
            JsonPath json = (JsonPath)collection.getValue();
            CoordinateSystem defaultCrs = (CoordinateSystem)this.collectionIdToDefaultCrs.get(collectionId);
            if (defaultCrs == null) continue;
            collectionsData.add(new Object[]{collectionId, json, defaultCrs});
        }
        return collectionsData.iterator();
    }

    @Test(description="Implements A.2.2 Query, Parameter bbox-crs, Abstract Test 10 (Requirement /req/crs/fc-bbox-crs-default-value)", dataProvider="collectionDefaultCrs", dependsOnGroups={"crs-conformance"}, priority=1)
    public void verifyBboxCrsParameterDefault(String collectionId, JsonPath collection, CoordinateSystem defaultCrs) {
        String featuredUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuredUrl == null) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type application/geo+json)");
        }
        BBox bbox = JsonUtils.parseSpatialExtent((Map)collection.get());
        if (bbox == null) {
            throw new SkipException("Collection with id " + collectionId + " has no spatial extent");
        }
        GeometryTransformer geometryTransformer = new GeometryTransformer(bbox.getCrs(), defaultCrs);
        BBox transformedBbox = geometryTransformer.transform(bbox);
        String bboxParameterValue = transformedBbox.asQueryParameter();
        Response responseWithBBox = (Response)this.init().baseUri(featuredUrl).param("bbox-crs", new Object[]{defaultCrs.getCode()}).param("bbox", new Object[]{bboxParameterValue}).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)responseWithBBox.then()).statusCode(200);
        Response responseWithoutBBox = (Response)this.init().baseUri(featuredUrl).param("bbox", new Object[]{bboxParameterValue}).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)responseWithoutBBox.then()).statusCode(200);
        this.assertSameFeatures(responseWithBBox.jsonPath(), responseWithoutBBox.jsonPath());
    }
}

