/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.core.apidefinition;

import com.reprezen.kaizen.oasparser.OpenApi3Parser;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.CommonFixture;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ApiDefinition
extends CommonFixture {
    private String response;
    private String apiUrl;

    @BeforeClass(dependsOnMethods={"initCommonFixture"})
    public void retrieveApiUrl() {
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET);
        JsonPath jsonPath = request.jsonPath();
        this.apiUrl = this.parseApiUrl(jsonPath);
    }

    @Test(description="Implements A.2.3. API Definition Path {root}/api (link), Abstract Test 5 (Requirement /req/core/api-definition-op)", groups={"apidefinition"}, dependsOnGroups={"landingpage"})
    public void openapiDocumentRetrieval() {
        if (this.apiUrl == null || this.apiUrl.isEmpty()) {
            throw new AssertionError((Object)"Path to the API Definition could not be constructed from the landing page");
        }
        Response request = (Response)this.init().baseUri(this.apiUrl).accept("application/vnd.oai.openapi+json;version=3.0").when().request(Method.GET);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.asString();
    }

    @Test(description="Implements A.2.3. API Definition Path {root}/api (link), Abstract Test 6 (Requirement /req/core/api-definition-success)", groups={"apidefinition"}, dependsOnMethods={"openapiDocumentRetrieval"})
    public void apiDefinitionValidation(ITestContext testContext) throws MalformedURLException {
        OpenApi3Parser parser = new OpenApi3Parser();
        OpenApi3 apiModel = parser.parse(this.response, new URL(this.apiUrl), true);
        EtsAssert.assertTrue(apiModel.isValid(), this.createValidationMsg(apiModel));
        testContext.getSuite().setAttribute(SuiteAttribute.API_MODEL.getName(), (Object)apiModel);
    }

    private String parseApiUrl(JsonPath jsonPath) {
        Iterator<Map<String, Object>> iterator = JsonUtils.parseAsListOfMaps("links", jsonPath).iterator();
        while (iterator.hasNext()) {
            Map<String, Object> link;
            Map<String, Object> linkMap = link = iterator.next();
            Object rel = linkMap.get("rel");
            Object type = linkMap.get("type");
            if (!"service-desc".equals(rel) || !"application/vnd.oai.openapi+json;version=3.0".equals(type.toString().replace(" ", ""))) continue;
            Object url = (String)linkMap.get("href");
            if (!((String)url).startsWith("http")) {
                String path = url;
                if (null != this.rootUri.getScheme() && !this.rootUri.getScheme().isEmpty()) {
                    url = this.rootUri.getScheme() + ":";
                }
                if (null != this.rootUri.getAuthority() && !this.rootUri.getAuthority().isEmpty()) {
                    url = (String)url + "//" + this.rootUri.getAuthority();
                }
                url = (String)url + path;
                if (null != this.rootUri.getQuery() && !this.rootUri.getQuery().isEmpty()) {
                    url = (String)url + "?" + this.rootUri.getQuery();
                }
                if (null != this.rootUri.getFragment() && !this.rootUri.getFragment().isEmpty()) {
                    url = (String)url + "#" + this.rootUri.getFragment();
                }
            }
            return url;
        }
        return null;
    }

    private String createValidationMsg(OpenApi3 model) {
        StringBuilder sb = new StringBuilder();
        sb.append("API definition document is not valid. Found following validation items:");
        if (!model.isValid()) {
            for (ValidationResults.ValidationItem item : model.getValidationItems()) {
                sb.append("  - ").append(item.getSeverity()).append(": ").append(item.toString()).append("\n");
            }
        }
        return sb.toString();
    }
}

