/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.core.collections;

import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Schema;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.locationtech.jts.io.ParseException;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.conformance.core.collections.AbstractFeatures;
import org.opengis.cite.ogcapifeatures10.conformance.core.collections.FeaturesAssertions;
import org.opengis.cite.ogcapifeatures10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeaturesLimit
extends AbstractFeatures {
    @DataProvider(name="collectionItemUrisWithLimits")
    public Iterator<Object[]> collectionItemUrisWithLimits(ITestContext testContext) {
        URI iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
        ArrayList<Object[]> collectionsWithLimits = new ArrayList<Object[]>();
        for (Map collection : this.collections) {
            String collectionId = (String)collection.get("id");
            List<TestPoint> testPoints = OpenApiUtils.retrieveTestPointsForCollection(this.getApiModel(), iut, collectionId);
            for (TestPoint testPoint : testPoints) {
                Parameter limit = OpenApiUtils.retrieveParameterByName(testPoint.getPath(), this.getApiModel(), "limit");
                if (limit == null || limit.getSchema() == null) continue;
                int min = limit.getSchema().getMinimum().intValue();
                int max = -1;
                Number maximumLimitNumber = limit.getSchema().getMaximum();
                if (maximumLimitNumber != null) {
                    max = maximumLimitNumber.intValue();
                }
                if (min == max) {
                    collectionsWithLimits.add(new Object[]{collection, min, max});
                    continue;
                }
                collectionsWithLimits.add(new Object[]{collection, min, max});
                int betweenMinAndMax = min + (max - min) / 2 > 100 ? 100 : min + (max - min) / 2;
                collectionsWithLimits.add(new Object[]{collection, betweenMinAndMax, max});
            }
        }
        return collectionsWithLimits.iterator();
    }

    @Test(description="A.2.7. Features {root}/collections/{collectionId}/items - Limit, Abstract Test 16: (Requirement /req/core/fc-limit-definition)", dataProvider="collectionPaths", dependsOnGroups={"featuresBase"}, alwaysRun=true)
    public void limitParameterDefinition(TestPoint testPoint) {
        Parameter limit = OpenApiUtils.retrieveParameterByName(testPoint.getPath(), this.getApiModel(), "limit");
        Assert.assertNotNull((Object)limit, (String)("Required limit parameter for collections path '" + testPoint.getPath() + "'  in OpenAPI document is missing"));
        String msg = "Expected property '%s' with value '%s' but was '%s'";
        Assert.assertEquals((String)limit.getName(), (String)"limit", (String)String.format(msg, "name", "limit", limit.getName()));
        Assert.assertEquals((String)limit.getIn(), (String)"query", (String)String.format(msg, "in", "query", limit.getIn()));
        EtsAssert.assertFalse(this.isRequired(limit), String.format(msg, "required", "false", limit.getRequired()));
        Assert.assertEquals((String)limit.getStyle(), (String)"form", (String)String.format(msg, "style", "form", limit.getStyle()));
        EtsAssert.assertFalse(this.isExplode(limit), String.format(msg, "explode", "false", limit.getExplode()));
        Schema schema = limit.getSchema();
        Assert.assertEquals((String)schema.getType(), (String)"integer", (String)String.format(msg, "schema -> type", "integer", schema.getType()));
        FeaturesAssertions.assertIntegerGreaterOrEqualsZero(schema.getMinimum(), "schema -> minimum");
        FeaturesAssertions.assertIntegerGreaterOrEqualsZero(schema.getDefault(), "schema -> default");
    }

    @Test(description="A.2.7. Features {root}/collections/{collectionId}/items - Limit, Abstract Test 13: (Requirement /req/core/fc-op)", dataProvider="collectionItemUrisWithLimits", dependsOnGroups={"featuresBase"}, alwaysRun=true)
    public void validateFeaturesWithLimitOperation(Map<String, Object> collection, int limit, int max) {
        String collectionId = (String)collection.get("id");
        String getFeaturesUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (getFeaturesUrl == null || getFeaturesUrl.isEmpty()) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type application/geo+json)");
        }
        ZonedDateTime timeStampBeforeResponse = ZonedDateTime.now();
        Response response = (Response)this.init().baseUri(getFeaturesUrl).accept("application/geo+json").param("limit", new Object[]{limit}).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        ZonedDateTime timeStampAfterResponse = ZonedDateTime.now();
        AbstractFeatures.ResponseData responseData = new AbstractFeatures.ResponseData(response, timeStampBeforeResponse, timeStampAfterResponse);
        this.collectionIdAndResponse.put(this.asKey(collectionId, limit), responseData);
    }

    @Test(description="A.2.7. Features {root}/collections/{collectionId}/items - Limit, Abstract Test 17: (Requirement /req/core/fc-limit-response)", dataProvider="collectionItemUrisWithLimits", dependsOnMethods={"validateFeaturesWithLimitOperation"}, alwaysRun=true)
    public void validateFeaturesWithLimitResponse(Map<String, Object> collection, int limit, int max) {
        String collectionId = (String)collection.get("id");
        AbstractFeatures.ResponseData response = (AbstractFeatures.ResponseData)this.collectionIdAndResponse.get(this.asKey(collectionId, limit));
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collectionId);
        }
        JsonPath jsonPath = response.jsonPath();
        int numberOfFeatures = JsonUtils.parseAsList("features", jsonPath).size();
        int expectedLimit = limit > max ? max : limit;
        EtsAssert.assertTrue(numberOfFeatures <= expectedLimit, "Number of features for collection with name " + collectionId + " is unexpected (was " + numberOfFeatures + "), expected are " + limit + " or less");
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Limit, Abstract Test 2, Test Method 2 (Requirement /req/core/crs84)", dataProvider="collectionItemUrisWithLimits", dependsOnMethods={"validateFeaturesWithLimitOperation"}, alwaysRun=true)
    public void validateFeaturesWithLimitResponse_GeometryInCRS84(Map<String, Object> collection, int limit, int max) throws ParseException {
        String collectionId = (String)collection.get("id");
        this.validateGeometriesInCrs84(this.asKey(collectionId, limit));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Limit, Abstract Test 22, Test Method 1 (Requirement /req/core/fc-response)", dataProvider="collectionItemUrisWithLimits", dependsOnMethods={"validateFeaturesWithLimitOperation"}, alwaysRun=true)
    public void validateFeaturesWithLimitResponse_TypeProperty(Map<String, Object> collection, int limit, int max) {
        String collectionId = (String)collection.get("id");
        this.validateTypeProperty(this.asKey(collectionId, limit));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Limit, Abstract Test 22, Test Method 2 (Requirement /req/core/fc-response)", dataProvider="collectionItemUrisWithLimits", dependsOnMethods={"validateFeaturesWithLimitOperation"}, alwaysRun=true)
    public void validateFeaturesWithLimitResponse_FeaturesProperty(Map<String, Object> collection, int limit, int max) {
        String collectionId = (String)collection.get("id");
        this.validateFeaturesProperty(this.asKey(collectionId, limit));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Limit, Abstract Test 22, Test Method 4 (Requirement /req/core/fc-response) - Abstract Test 23 (Requirement /req/core/fc-links, /req/core/fc-rel-type)", dataProvider="collectionItemUrisWithLimits", dependsOnMethods={"validateFeaturesWithLimitOperation"}, alwaysRun=true)
    public void validateFeaturesWithLimitResponse_Links(Map<String, Object> collection, int limit, int max) {
        String collectionId = (String)collection.get("id");
        this.validateLinks(this.asKey(collectionId, limit));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Limit, Abstract Test 22, Test Method 5 (Requirement /req/core/fc-response) - Abstract Test 24 (Requirement /req/core/fc-timeStamp)", dataProvider="collectionItemUrisWithLimits", dependsOnMethods={"validateFeaturesWithLimitOperation"}, alwaysRun=true)
    public void validateFeaturesWithLimitResponse_TimeStamp(Map<String, Object> collection, int limit, int max) {
        String collectionId = (String)collection.get("id");
        this.validateTimeStamp(this.asKey(collectionId, limit));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Limit, Abstract Test 22, Test Method 6 (Requirement /req/core/fc-response) - Abstract Test 25 (Requirement /req/core/fc-numberMatched)", dataProvider="collectionItemUrisWithLimits", dependsOnMethods={"validateFeaturesWithLimitOperation"}, alwaysRun=true)
    public void validateFeaturesWithLimitResponse_NumberMatched(Map<String, Object> collection, int limit, int max) throws URISyntaxException {
        String collectionId = (String)collection.get("id");
        this.validateNumberMatched(this.asKey(collectionId, limit));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items, Limit, Abstract Test 22, Test Method 7 (Requirement /req/core/fc-response) - Abstract Test 26 (Requirement /req/core/fc-numberReturned)", dataProvider="collectionItemUrisWithLimits", dependsOnMethods={"validateFeaturesWithLimitOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_NumberReturned(Map<String, Object> collection, int limit, int max) {
        String collectionId = (String)collection.get("id");
        this.validateNumberReturned(this.asKey(collectionId, limit));
    }

    private CollectionIdWithLimitKey asKey(String collectionId, int limit) {
        return new CollectionIdWithLimitKey(collectionId, limit);
    }

    private class CollectionIdWithLimitKey
    extends AbstractFeatures.CollectionResponseKey {
        int limit;

        public CollectionIdWithLimitKey(String collectionId, int limit) {
            super(collectionId);
            this.limit = limit;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollectionIdWithLimitKey that = (CollectionIdWithLimitKey)o;
            return this.limit == that.limit;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.limit);
        }
    }
}

