/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;
import org.opengis.cite.ogcapifeatures10.util.ClientUtils;
import org.opengis.cite.ogcapifeatures10.util.TestSuiteLogger;

public class URIUtils {
    public static File dereferenceURI(URI uriRef) throws IOException {
        if (null == uriRef || !uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        if (uriRef.getScheme().equalsIgnoreCase("file")) {
            return new File(uriRef);
        }
        Client client = ClientUtils.buildClient();
        WebTarget target = client.target(uriRef);
        Invocation.Builder builder = target.request();
        Response rsp = builder.buildGet().invoke();
        String suffix = null;
        if (rsp.getHeaders().getFirst((Object)"Content-Type").toString().endsWith("xml")) {
            suffix = ".xml";
        }
        File destFile = File.createTempFile("entity-", suffix);
        if (rsp.hasEntity()) {
            int bytesRead;
            Object entity = rsp.getEntity();
            if (!(entity instanceof InputStream)) {
                return null;
            }
            InputStream is = (InputStream)entity;
            FileOutputStream os = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            is.close();
            os.flush();
            ((OutputStream)os).close();
        }
        TestSuiteLogger.log(Level.FINE, "Wrote " + destFile.length() + " bytes to file at " + destFile.getAbsolutePath());
        return destFile;
    }
}

