/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10.datasettilesets;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opengis.cite.ogcapitiles10.CommonFixture;
import org.opengis.cite.ogcapitiles10.EtsAssert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class LandingPage
extends CommonFixture {
    private JsonPath response;

    @Test(description="Implements Abstract test A.10, addresses Requirement 11", groups={"landingpage"})
    public void landingPageRetrieval() {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List links = this.response.getList("links");
        boolean hasTilesets = false;
        for (Object link : links) {
            Map linkMap = (Map)link;
            Object linkType = linkMap.get("rel");
            if (!linkType.toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-vector") && !linkType.toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-map") && !linkType.toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-coverage")) continue;
            hasTilesets = true;
        }
        EtsAssert.assertTrue(hasTilesets, "Requirement 11 states that if the API has a mechanism for exposing root resources (e.g., a landing page), the API SHALL advertise at least one URI to retrieve a tilesets list provided by this service with a link having a rel value: http://www.opengis.net/def/rel/ogc/1.0/tilesets-vector, http://www.opengis.net/def/rel/ogc/1.0/tilesets-map or http://www.opengis.net/def/rel/ogc/1.0/tilesets-coverage. However, the landing page did not have any such links.");
    }

    private Set<String> collectLinkTypes(List<Object> links) {
        HashSet<String> linkTypes = new HashSet<String>();
        for (Object link : links) {
            Map linkMap = (Map)link;
            Object linkType = linkMap.get("rel");
            linkTypes.add((String)linkType);
        }
        return linkTypes;
    }
}

