/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;

public class BBox {
    private static final String PATTERN = "###.0000000";
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;

    public BBox(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public String asQueryParameter() {
        StringBuilder sb = new StringBuilder();
        DecimalFormat formatter = this.formatter();
        sb.append(formatter.format(this.minX)).append(",");
        sb.append(formatter.format(this.minY)).append(",");
        sb.append(formatter.format(this.maxX)).append(",");
        sb.append(formatter.format(this.maxY));
        return sb.toString();
    }

    public String toString() {
        return this.asQueryParameter();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBox bBox = (BBox)o;
        return Double.compare(bBox.minX, this.minX) == 0 && Double.compare(bBox.minY, this.minY) == 0 && Double.compare(bBox.maxX, this.maxX) == 0 && Double.compare(bBox.maxY, this.maxY) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.maxX, this.maxY);
    }

    private DecimalFormat formatter() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(PATTERN);
        return df;
    }
}

