/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.util;

import com.occamlab.te.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class HtmlReport {
    private static final Logger LOGR = Logger.getLogger(HtmlReport.class.getPackage().getName());

    public static File getHtmlResultZip(String outputDirectory) throws FileNotFoundException {
        File htmlResult = HtmlReport.earlHtmlReport(outputDirectory);
        File htmlResultFile = new File(outputDirectory, "result.zip");
        try {
            HtmlReport.zipDir(htmlResultFile, htmlResult);
        }
        catch (Exception e) {
            LOGR.log(Level.SEVERE, "Could not create zip file with html results.", e);
        }
        return htmlResultFile;
    }

    public static File earlHtmlReport(String outputDir) throws FileNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL resourceDirUrl = cl.getResource("com/occamlab/te/earl/lib");
        String earlXsl = cl.getResource("com/occamlab/te/earl_html_report.xsl").toString();
        File htmlOutput = new File(outputDir, "result");
        htmlOutput.mkdir();
        LOGR.fine("HTML output is written to directory " + htmlOutput);
        File earlResult = new File(outputDir, "earl-results.rdf");
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer(new StreamSource(earlXsl));
            transformer.setParameter("outputDir", htmlOutput);
            File indexHtml = new File(htmlOutput, "index.html");
            indexHtml.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(indexHtml);
            transformer.transform(new StreamSource(earlResult), new StreamResult(outputStream));
            outputStream.close();
            Utils.copyResourceDir(resourceDirUrl, htmlOutput);
        }
        catch (Exception e) {
            LOGR.log(Level.SEVERE, "Transformation of EARL to HTML failed.", e);
            throw new RuntimeException(e);
        }
        if (!htmlOutput.exists()) {
            throw new FileNotFoundException("HTML results not found at " + htmlOutput.getAbsolutePath());
        }
        return htmlOutput;
    }

    public static void zipDir(File zipFile, File dirObj) throws Exception {
        if (!dirObj.isDirectory()) {
            LOGR.severe(dirObj.getName() + " is not a directory");
            System.exit(1);
        }
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            LOGR.fine("Creating : " + zipFile);
            HtmlReport.addDir(dirObj, out);
            out.close();
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    private static void addDir(File dirObj, ZipOutputStream out) throws IOException {
        File[] dirList = dirObj.listFiles();
        byte[] tmpBuf = new byte[1024];
        for (int i = 0; i < dirList.length; ++i) {
            int len;
            if (dirList[i].isDirectory()) {
                HtmlReport.addDir(dirList[i], out);
                continue;
            }
            FileInputStream in = new FileInputStream(dirList[i].getAbsolutePath());
            LOGR.fine(" Adding: " + dirList[i].getAbsolutePath());
            out.putNextEntry(new ZipEntry(dirList[i].getName()));
            while ((len = in.read(tmpBuf)) > 0) {
                out.write(tmpBuf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }
}

