/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class IOUtils {
    private static final Logger LOGR = Logger.getLogger(IOUtils.class.getName());

    public static InputStream DocumentToInputStream(Document edoc) throws IOException {
        final Document doc = edoc;
        final PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream();
        pis.connect(pos);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    Transformer transformer = tFactory.newTransformer();
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.transform(new DOMSource(doc), new StreamResult(pos));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error converting Document to InputStream.  " + e.getMessage());
                }
                finally {
                    try {
                        pos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }, "IOUtils.DocumentToInputStream(Document edoc)").start();
        return pis;
    }

    public static String inputStreamToString(InputStream in) {
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"), 1024);
            while ((line = br.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (IOException iox) {
            LOGR.warning(iox.getMessage());
        }
        return buffer.toString();
    }

    public static byte[] inputStreamToBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            System.out.println("Error converting InputStream to byte[]: " + e.getMessage());
        }
        return out.toByteArray();
    }

    public static boolean writeObjectToFile(Object obj, File f) {
        try {
            FileOutputStream fout = new FileOutputStream(f);
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(obj);
            oos.close();
        }
        catch (Exception e) {
            System.out.println("Error writing Object to file: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean writeBytesToFile(byte[] bytes, File f) {
        try {
            FileOutputStream fout = new FileOutputStream(f);
            fout.write(bytes);
            fout.close();
        }
        catch (Exception e) {
            System.out.println("Error writing byte[] to file: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static Object readObjectFromFile(File f) {
        Object obj = null;
        try {
            FileInputStream fin = new FileInputStream(f);
            ObjectInputStream ois = new ObjectInputStream(fin);
            obj = ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            System.out.println("Error reading Object from file: " + e.getMessage());
            return null;
        }
        return obj;
    }

    public static byte[] readBytesFromFile(File f) {
        byte[] bytes = null;
        try {
            int filesize = (int)f.length();
            bytes = new byte[filesize];
            DataInputStream in = new DataInputStream(new FileInputStream(f));
            in.readFully(bytes);
            in.close();
        }
        catch (Exception e) {
            System.out.println("Error reading byte[] from file: " + e.getMessage());
            return null;
        }
        return bytes;
    }

    public static Object pollFile(File file, int timeout, int interval) throws InterruptedException {
        int fullTimeout = Math.round(timeout * 1000);
        int timeoutShard = Math.round(fullTimeout / interval);
        for (int i = 0; i < interval; ++i) {
            Thread.sleep(timeoutShard);
            if (!file.exists()) continue;
            return IOUtils.readObjectFromFile(file);
        }
        return null;
    }

    public static Object pollFile(File file, int timeout) throws InterruptedException {
        return IOUtils.pollFile(file, timeout, 25);
    }
}

