/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10.conformance;

public enum RequirementClass {
    CORE("http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/core");

    private final String conformanceClass;
    private final String mediaTypeFeaturesAndCollections;
    private final String mediaTypeOtherResources;

    private RequirementClass(String conformanceClass) {
        this(conformanceClass, null, null);
    }

    private RequirementClass(String conformanceClass, String mediaTypeFeaturesAndCollections, String mediaTypeOtherResources) {
        this.conformanceClass = conformanceClass;
        this.mediaTypeFeaturesAndCollections = mediaTypeFeaturesAndCollections;
        this.mediaTypeOtherResources = mediaTypeOtherResources;
    }

    public boolean hasMediaTypeForFeaturesAndCollections() {
        return this.mediaTypeFeaturesAndCollections != null;
    }

    public String getMediaTypeFeaturesAndCollections() {
        return this.mediaTypeFeaturesAndCollections;
    }

    public boolean hasMediaTypeForOtherResources() {
        return this.mediaTypeOtherResources != null;
    }

    public String getMediaTypeOtherResources() {
        return this.mediaTypeOtherResources;
    }

    public static RequirementClass byConformanceClass(String conformanceClass) {
        for (RequirementClass requirementClass : RequirementClass.values()) {
            if (!requirementClass.conformanceClass.equals(conformanceClass)) continue;
            return requirementClass;
        }
        return null;
    }
}

