/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10.conformance;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.opengis.cite.ogcapitiles10.CommonFixture;
import org.opengis.cite.ogcapitiles10.SuiteAttribute;
import org.opengis.cite.ogcapitiles10.conformance.RequirementClass;
import org.opengis.cite.ogcapitiles10.openapi3.TestPoint;
import org.opengis.cite.ogcapitiles10.openapi3.UriBuilder;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class Conformance
extends CommonFixture {
    private List<RequirementClass> requirementClasses;

    @DataProvider(name="conformanceUris")
    public Object[][] conformanceUris(ITestContext testContext) {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        OpenApi3 apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
        URI iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
        TestPoint tp = new TestPoint(this.rootUri.toString(), "/conformance", null);
        ArrayList<TestPoint> testPoints = new ArrayList<TestPoint>();
        testPoints.add(tp);
        Object[][] testPointsData = new Object[1][];
        int i = 0;
        for (TestPoint testPoint : testPoints) {
            testPointsData[i++] = new Object[]{testPoint};
        }
        return testPointsData;
    }

    @AfterClass
    public void storeRequirementClassesInTestContext(ITestContext testContext) {
        testContext.getSuite().setAttribute(SuiteAttribute.REQUIREMENTCLASSES.getName(), this.requirementClasses);
    }

    @Test(description="Implements Abstract test A.1, Requirement 7: /req/core/conformance-success", groups={"conformance"}, dataProvider="conformanceUris")
    public void validateConformanceOperationAndResponse(TestPoint testPoint) {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        String testPointUri = new UriBuilder(testPoint).buildUrl();
        Response response = (Response)this.init().baseUri(testPointUri).accept(ContentType.JSON).when().request(Method.GET);
        this.validateConformanceOperationResponse(testPointUri, response);
    }

    private void validateConformanceOperationResponse(String testPointUri, Response response) {
        ((ValidatableResponse)response.then()).statusCode(200);
        JsonPath jsonPath = response.jsonPath();
        this.requirementClasses = this.parseAndValidateRequirementClasses(jsonPath);
        Assert.assertTrue((boolean)this.requirementClasses.contains((Object)RequirementClass.CORE), (String)("Requirement class \"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/core\" is not available from path " + testPointUri));
    }

    List<RequirementClass> parseAndValidateRequirementClasses(JsonPath jsonPath) {
        List conformsTo = jsonPath.getList("conformsTo");
        Assert.assertNotNull((Object)conformsTo, (String)"Missing member 'conformsTo'.");
        ArrayList<RequirementClass> requirementClasses = new ArrayList<RequirementClass>();
        for (Object conformTo : conformsTo) {
            if (conformTo instanceof String) {
                String conformanceClass = (String)conformTo;
                RequirementClass requirementClass = RequirementClass.byConformanceClass(conformanceClass);
                if (requirementClass == null) continue;
                requirementClasses.add(requirementClass);
                continue;
            }
            throw new AssertionError((Object)("At least one element array 'conformsTo' is not a string value (" + conformTo + ")"));
        }
        return requirementClasses;
    }
}

