/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10.geodatatilesets;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opengis.cite.ogcapitiles10.CommonFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class GeospatialDataResource
extends CommonFixture {
    private JsonPath response;

    @Test(description="Implements Abstract test A.12, addresses Requirement 13", groups={"geodata"})
    public void geospatialResourceTilesetsLinksCheck() {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        String resultString = "";
        resultString = this.processNestedTilesetCheck();
        if (resultString.length() > 0) {
            Assert.fail((String)"Requirement 13 states that if the Web API based server has a mechanism for geospatial data resources to expose links to geospatial resource aspects (e.g., feature items, metadata\u2026\u200b), the API implementation SHALL include at least one of three link with the href pointing to tilesets list for geospatial data resources and with rel: http://www.opengis.net/def/rel/ogc/1.0/tilesets-vector, http://www.opengis.net/def/rel/ogc/1.0/tilesets-map and http://www.opengis.net/def/rel/ogc/1.0/tilesets-coverage. However, none were found.");
        }
    }

    @Test(description="Implements Abstract test A.13, addresses Requirement 14", groups={"geodata"})
    public void geospatialResourceTilesetsRetrieval() {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        String resultString = "";
        resultString = this.processNestedTilesResponse();
        Assert.assertTrue((resultString.length() == 0 ? 1 : 0) != 0, (String)("Requirement 14 states that the geospatial data resource SHALL have an associated list of at least one tileset accessible at \u2026\u200b/tiles supporting an HTTP GET operation. However, " + resultString));
    }

    private String processNestedTilesetCheck() {
        StringBuffer errorMessages = new StringBuffer();
        Response request2 = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        ((ValidatableResponse)request2.then()).statusCode(200);
        this.response = request2.jsonPath();
        List collectionsList = this.response.getList("collections");
        boolean foundTilesetsLink = false;
        for (Object collectionObj : collectionsList) {
            HashMap collection = (HashMap)collectionObj;
            ArrayList collectionLinks = (ArrayList)collection.get("links");
            for (int q = 0; q < collectionLinks.size(); ++q) {
                HashMap linkItem = (HashMap)collectionLinks.get(q);
                if (!linkItem.get("rel").toString().trim().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-") || foundTilesetsLink) continue;
                String newURL = this.formatLinkURI(this.rootUri.getScheme(), this.rootUri.getHost(), linkItem.get("href").toString());
                Response tilesRequest = (Response)this.init().baseUri(newURL).accept(ContentType.JSON).when().request(Method.GET);
                ((ValidatableResponse)tilesRequest.then()).statusCode(200);
                JsonPath tilesResponse = tilesRequest.jsonPath();
                List tilesetsList = tilesResponse.getList("tilesets");
                foundTilesetsLink = true;
            }
        }
        errorMessages.append(foundTilesetsLink ? "" : "No tilesets links found in the geospatial data resources.");
        return errorMessages.toString();
    }

    private String processNestedTilesResponse() {
        StringBuffer errorMessages = new StringBuffer();
        Response request2 = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        ((ValidatableResponse)request2.then()).statusCode(200);
        this.response = request2.jsonPath();
        List collectionsList = this.response.getList("collections");
        boolean foundTilesetsLink = false;
        for (Object collectionObj : collectionsList) {
            HashMap collection = (HashMap)collectionObj;
            ArrayList collectionLinks = (ArrayList)collection.get("links");
            for (int q = 0; q < collectionLinks.size(); ++q) {
                HashMap linkItem = (HashMap)collectionLinks.get(q);
                if (!linkItem.get("rel").toString().trim().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-") || !linkItem.get("href").toString().endsWith("/tiles") && !linkItem.get("href").toString().contains("/tiles?") || foundTilesetsLink) continue;
                String newURL = this.formatLinkURI(this.rootUri.getScheme(), this.rootUri.getHost(), linkItem.get("href").toString());
                Response tilesRequest = (Response)this.init().baseUri(newURL).accept(ContentType.JSON).when().request(Method.GET);
                ((ValidatableResponse)tilesRequest.then()).statusCode(200);
                JsonPath tilesResponse = tilesRequest.jsonPath();
                List tilesetsList = tilesResponse.getList("tilesets");
                foundTilesetsLink = true;
            }
        }
        errorMessages.append(foundTilesetsLink ? "" : "No tilesets link with an href ending with '.../tiles' was found in the geospatial data resources.");
        return errorMessages.toString();
    }

    private Set<String> collectLinkTypes(List<Object> links) {
        HashSet<String> linkTypes = new HashSet<String>();
        for (Object link : links) {
            Map linkMap = (Map)link;
            Object linkType = linkMap.get("rel");
            linkTypes.add((String)linkType);
        }
        return linkTypes;
    }
}

