/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TEClassLoader
extends ClassLoader {
    List<File> resourcesDirs;
    ClassLoader cl;
    HashSet<String> registeredClasses;
    private static Logger logger = Logger.getLogger("com.occamlab.te.TEClassLoader");

    private static List<File> resourcesDirsList(File resourcesDir) {
        ArrayList<File> resourcesDirs = new ArrayList<File>();
        if (resourcesDir != null) {
            resourcesDirs.add(resourcesDir);
        }
        return resourcesDirs;
    }

    public TEClassLoader() {
        this(TEClassLoader.resourcesDirsList(null));
    }

    public TEClassLoader(File resourcesDir) {
        this(TEClassLoader.resourcesDirsList(resourcesDir));
    }

    public TEClassLoader(List<File> resourcesDirs) {
        this.resourcesDirs = resourcesDirs;
        this.cl = Thread.currentThread().getContextClassLoader();
        this.registeredClasses = new HashSet();
        this.registeredClasses.add("com.occamlab.te.parsers.HTTPParser");
        this.registeredClasses.add("com.occamlab.te.parsers.SchematronValidatingParser");
        this.registeredClasses.add("com.occamlab.te.parsers.XMLValidatingParser");
        this.registeredClasses.add("com.occamlab.te.parsers.XSLTransformationParser");
    }

    @Override
    public URL getResource(String name) {
        for (File resourcesDir : this.resourcesDirs) {
            File f = new File(resourcesDir, name);
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "getResource", e);
            }
        }
        return this.cl.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL u;
        if (this.resourcesDirs.size() > 0 && (u = this.getResource(name)) != null) {
            try {
                return u.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.cl.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = this.cl.getResources(name);
        URL u = this.getResource(name);
        if (this.resourcesDirs.size() > 0 && u != null) {
            Vector<URL> v = new Vector<URL>();
            v.add(u);
            while (resources.hasMoreElements()) {
                v.add(resources.nextElement());
            }
            return v.elements();
        }
        return resources;
    }

    private Class<?> readClass(String name) {
        String filename = name.replace('.', '/') + ".class";
        try {
            InputStream in = this.getResourceAsStream(filename);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            int i = in.read();
            while (i >= 0) {
                baos.write(i);
                i = in.read();
            }
            in.close();
            return this.defineClass(name, baos.toByteArray(), 0, baos.size());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "readClass", e);
            return null;
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            for (String registeredClass : this.registeredClasses) {
                if (!name.startsWith(registeredClass)) continue;
                c = this.readClass(name);
                break;
            }
        }
        if (c == null) {
            try {
                c = this.cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null) {
            c = this.readClass(name);
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

