/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.Builder;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.ReferenceManager;
import com.reprezen.jsonoverlay.ScalarOverlay;
import com.reprezen.jsonoverlay.SerializationOptions;

public final class StringOverlay
extends ScalarOverlay<String> {
    public static OverlayFactory<String> factory = new OverlayFactory<String>(){

        @Override
        protected Class<StringOverlay> getOverlayClass() {
            return StringOverlay.class;
        }

        public StringOverlay _create(String value, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new StringOverlay(value, parent, refMgr);
        }

        public StringOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new StringOverlay(json, parent, refMgr);
        }
    };

    private StringOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(json, parent, factory, refMgr);
    }

    private StringOverlay(String value, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(value, parent, factory, refMgr);
    }

    @Override
    protected String _fromJson(JsonNode json) {
        return json.isTextual() ? json.textValue() : null;
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        return this.value != null ? StringOverlay._jsonScalar((String)this.value) : StringOverlay._jsonMissing();
    }

    @Override
    protected OverlayFactory<String> _getFactory() {
        return factory;
    }

    @Override
    public String toString() {
        return this.value != null ? (String)this.value : "";
    }

    public static Builder<String> builder(JsonOverlay<?> modelMember) {
        return new Builder<String>(factory, modelMember);
    }

    public static JsonOverlay<String> create(JsonOverlay<?> modelMember) {
        return StringOverlay.builder(modelMember).build();
    }

    public static JsonOverlay<String> create(String value, JsonOverlay<?> modelMember) {
        JsonOverlay<String> result = StringOverlay.create(modelMember);
        result._set(value);
        return result;
    }
}

