/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10;

import com.sun.jersey.api.client.Client;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import org.opengis.cite.ogcapitiles10.SuiteAttribute;
import org.opengis.cite.ogcapitiles10.TestRunArg;
import org.opengis.cite.ogcapitiles10.util.ClientUtils;
import org.opengis.cite.ogcapitiles10.util.TestSuiteLogger;
import org.opengis.cite.ogcapitiles10.util.URIUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
        this.registerClientComponent(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
        if (null != System.getProperty("deleteSubjectOnFinish")) {
            this.deleteTempFiles(suite);
            System.getProperties().remove("deleteSubjectOnFinish");
        }
    }

    void processSuiteParameters(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String iutParam = params.get(TestRunArg.IUT.toString());
        if (null != iutParam && !iutParam.isEmpty()) {
            URI iutRef = URI.create(iutParam.trim());
            suite.setAttribute(SuiteAttribute.IUT.getName(), iutRef);
            File entityFile = null;
            try {
                entityFile = URIUtils.dereferenceURI(iutRef);
            }
            catch (IOException iox) {
                throw new RuntimeException("Failed to dereference resource located at " + iutRef, iox);
            }
            TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", entityFile.getAbsolutePath(), entityFile.length()));
            suite.setAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName(), entityFile);
        }
        String tileMatrixSetDefinitionURI = null;
        if (params.containsKey("tilematrixsetdefinitionuri") && (tileMatrixSetDefinitionURI = params.get("tilematrixsetdefinitionuri")) != null) {
            suite.setAttribute(SuiteAttribute.TILE_MATRIX_SET_DEFINITION_URI.getName(), tileMatrixSetDefinitionURI);
        }
        String urlTemplateForTiles = null;
        if (params.containsKey("urltemplatefortiles") && (urlTemplateForTiles = params.get("urltemplatefortiles")) != null) {
            suite.setAttribute(SuiteAttribute.URL_TEMPLATE_FOR_TILES.getName(), urlTemplateForTiles);
        }
        String tileMatrix = null;
        if (params.containsKey("tilematrix") && (tileMatrix = params.get("tilematrix")) != null) {
            suite.setAttribute(SuiteAttribute.TILE_MATRIX.getName(), tileMatrix);
        }
        String minTileRow = null;
        if (params.containsKey("mintilerow") && (minTileRow = params.get("mintilerow")) != null) {
            suite.setAttribute(SuiteAttribute.MINIMUM_TILE_ROW.getName(), minTileRow);
        }
        String maxTileRow = null;
        if (params.containsKey("maxtilerow") && (maxTileRow = params.get("maxtilerow")) != null) {
            suite.setAttribute(SuiteAttribute.MAXIMUM_TILE_ROW.getName(), maxTileRow);
        }
        String minTileCol = null;
        if (params.containsKey("mintilecol") && (minTileCol = params.get("mintilecol")) != null) {
            suite.setAttribute(SuiteAttribute.MINIMUM_TILE_COLUMN.getName(), minTileCol);
        }
        String maxTileCol = null;
        if (params.containsKey("maxtilecol") && (maxTileCol = params.get("maxtilecol")) != null) {
            suite.setAttribute(SuiteAttribute.MAXIMUM_TILE_COLUMN.getName(), maxTileCol);
        }
        String noOfCollections = params.get(TestRunArg.NOOFCOLLECTIONS.toString());
        try {
            if (noOfCollections != null) {
                int noOfCollectionsInt = Integer.parseInt(noOfCollections);
                suite.setAttribute(SuiteAttribute.NO_OF_COLLECTIONS.getName(), noOfCollectionsInt);
            }
        }
        catch (NumberFormatException e) {
            TestSuiteLogger.log(Level.WARNING, String.format("Could not parse parameter %s: %s. Expected is a valid integer", TestRunArg.NOOFCOLLECTIONS.toString(), noOfCollections));
        }
    }

    void registerClientComponent(ISuite suite) {
        Client client = ClientUtils.buildClient();
        if (null != client) {
            suite.setAttribute(SuiteAttribute.CLIENT.getName(), client);
        }
    }

    void deleteTempFiles(ISuite suite) {
        if (TestSuiteLogger.isLoggable(Level.CONFIG)) {
            return;
        }
        File testSubjFile = (File)suite.getAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName());
        if (testSubjFile.exists()) {
            testSubjFile.delete();
        }
    }
}

