/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;
import org.opengis.cite.ogcapitiles10.util.TestSuiteLogger;

public class URIUtils {
    public static File dereferenceURI(URI uriRef) throws IOException {
        if (null == uriRef || !uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        if (uriRef.getScheme().equalsIgnoreCase("file")) {
            return new File(uriRef);
        }
        Client client = Client.create();
        WebResource webRes = client.resource(uriRef);
        ClientResponse rsp = webRes.get(ClientResponse.class);
        String suffix = null;
        if (rsp.getHeaders().getFirst("Content-Type").endsWith("xml")) {
            suffix = ".xml";
        }
        File destFile = File.createTempFile("entity-", suffix);
        if (rsp.hasEntity()) {
            int bytesRead;
            InputStream is = rsp.getEntityInputStream();
            FileOutputStream os = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            is.close();
            os.flush();
            ((OutputStream)os).close();
        }
        TestSuiteLogger.log(Level.FINE, "Wrote " + destFile.length() + " bytes to file at " + destFile.getAbsolutePath());
        return destFile;
    }
}

