/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.IJsonOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.ListOverlay;
import com.reprezen.jsonoverlay.MapOverlay;
import com.reprezen.jsonoverlay.PositionInfo;
import com.reprezen.jsonoverlay.PropertiesOverlay;
import com.reprezen.jsonoverlay.RefOverlay;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.SerializationOptions;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Overlay<V> {
    private JsonOverlay<V> overlay;

    public Overlay(JsonOverlay<V> overlay) {
        this.overlay = overlay;
    }

    public static <V> Overlay<V> of(JsonOverlay<V> overlay) {
        return new Overlay<V>(overlay);
    }

    public Overlay(IJsonOverlay<?> overlay) {
        JsonOverlay castOverlay;
        this.overlay = castOverlay = (JsonOverlay)overlay;
    }

    public static <V> Overlay<V> of(IJsonOverlay<V> overlay) {
        return new Overlay<V>(overlay);
    }

    public static <V> Overlay<Map<String, V>> of(MapOverlay<V> overlay) {
        return new Overlay<Map<String, V>>(overlay);
    }

    public static <V> Overlay<Map<String, V>> of(Map<String, V> map) {
        MapOverlay<V> overlay = Overlay.getSidebandOverlay(map);
        return overlay != null ? new Overlay<V>(overlay) : null;
    }

    public static <V> Overlay<List<V>> of(ListOverlay<V> overlay) {
        return new Overlay<List<V>>(overlay);
    }

    public static <V> Overlay<List<V>> of(List<V> list) {
        ListOverlay<V> overlay = Overlay.getSidebandOverlay(list);
        return overlay != null ? new Overlay<V>(overlay) : null;
    }

    public Overlay(MapOverlay<V> map, String key) {
        this.overlay = map._getOverlay(key);
    }

    public static <V> Overlay<V> of(MapOverlay<V> map, String key) {
        return new Overlay<V>(map, key);
    }

    public static <V> Overlay<V> of(Map<String, V> map, String key) {
        Overlay<Map<String, V>> mapOverlay = Overlay.of(map);
        return mapOverlay != null ? Overlay.of((MapOverlay)mapOverlay.getOverlay(), key) : null;
    }

    public Overlay(ListOverlay<V> list, int index) {
        this.overlay = list._getOverlay(index);
    }

    public static <V> Overlay<V> of(ListOverlay<V> list, int index) {
        return new Overlay<V>(list, index);
    }

    public static <V> Overlay<V> of(List<V> list, int index) {
        Overlay<List<V>> listOverlay = Overlay.of(list);
        return listOverlay != null ? Overlay.of((ListOverlay)listOverlay.getOverlay(), index) : null;
    }

    public Overlay(PropertiesOverlay<?> props, String fieldName) {
        JsonOverlay<?> overlay = props._getOverlay(fieldName);
        this.overlay = overlay;
    }

    public static <X> Overlay<X> of(PropertiesOverlay<?> props, String fieldName, Class<X> type) {
        return new Overlay(props, fieldName);
    }

    public static <X> Overlay<X> of(IJsonOverlay<?> props, String fieldName, Class<X> type) {
        if (props instanceof PropertiesOverlay) {
            PropertiesOverlay castProps = (PropertiesOverlay)props;
            return Overlay.of(castProps, fieldName, type);
        }
        return null;
    }

    public final V get() {
        return this.overlay._get();
    }

    public static <V> V get(JsonOverlay<V> overlay) {
        return overlay._get();
    }

    public final JsonOverlay<V> getOverlay() {
        return this.overlay;
    }

    public static <X> ListOverlay<X> getListOverlay(Overlay<List<X>> overlay) {
        if (overlay.getOverlay() instanceof ListOverlay) {
            ListOverlay<X> castOverlay = Overlay.getSidebandOverlay(overlay.get());
            return castOverlay;
        }
        return null;
    }

    public static <X> MapOverlay<X> getMapOverlay(Overlay<Map<String, X>> overlay) {
        if (overlay.getOverlay() instanceof MapOverlay) {
            MapOverlay<X> castOverlay = Overlay.getSidebandOverlay(overlay.get());
            return castOverlay;
        }
        return null;
    }

    public static PropertiesOverlay<?> getPropertiesOverlay(Overlay<PropertiesOverlay<?>> overlay) {
        if (overlay.getOverlay() instanceof PropertiesOverlay) {
            return (PropertiesOverlay)overlay.getOverlay();
        }
        return null;
    }

    public JsonOverlay<?> find(JsonPointer path) {
        return this.overlay._find(path);
    }

    public static JsonOverlay<?> find(JsonOverlay<?> overlay, JsonPointer path) {
        return overlay._find(path);
    }

    public JsonOverlay<?> find(String path) {
        return this.overlay._find(path);
    }

    public static <V, OV extends JsonOverlay<V>> JsonOverlay<?> find(OV overlay, String path) {
        return overlay._find(path);
    }

    public JsonNode toJson() {
        return this.overlay._toJson();
    }

    public static <V> JsonNode toJson(JsonOverlay<V> overlay) {
        return overlay._toJson();
    }

    public JsonNode toJson(SerializationOptions options) {
        return this.overlay._toJson(options);
    }

    public static <V> JsonNode toJson(JsonOverlay<V> overlay, SerializationOptions options) {
        return overlay._toJson(options);
    }

    public JsonNode toJson(SerializationOptions.Option ... options) {
        return this.overlay._toJson(options);
    }

    public static <V> JsonNode toJson(JsonOverlay<V> overlay, SerializationOptions.Option ... options) {
        return overlay._toJson(options);
    }

    public JsonNode getParsedJson() {
        return this.overlay._getParsedJson();
    }

    public static JsonNode getParsedJson(JsonOverlay<?> overlay) {
        return overlay._getParsedJson();
    }

    public boolean isPresent() {
        return this.overlay._isPresent();
    }

    public static <V> boolean isPresent(JsonOverlay<V> overlay) {
        return overlay._isPresent();
    }

    public boolean isElaborated() {
        return this.overlay._isElaborated();
    }

    public static <V> boolean isElaborated(JsonOverlay<V> overlay) {
        return overlay._isElaborated();
    }

    public JsonOverlay<?> getParent() {
        return this.overlay._getParent();
    }

    public static <V> JsonOverlay<?> getParent(JsonOverlay<V> overlay) {
        return overlay._getParent();
    }

    public PropertiesOverlay<?> getParentPropertiesOverlay() {
        JsonOverlay<?> parent = this.getParent();
        while (parent != null) {
            if (parent instanceof PropertiesOverlay) {
                return (PropertiesOverlay)parent;
            }
            parent = Overlay.getParent(parent);
        }
        return null;
    }

    public static <V> PropertiesOverlay<?> getParentPropertiesOverlay(JsonOverlay<V> overlay) {
        return new Overlay<V>(overlay).getParentPropertiesOverlay();
    }

    public String getPathInParent() {
        return this.overlay._getPathInParent();
    }

    public static String getPathInParent(JsonOverlay<?> overlay) {
        return overlay._getPathInParent();
    }

    public JsonOverlay<?> getRoot() {
        return this.overlay._getRoot();
    }

    public static JsonOverlay<?> getRoot(JsonOverlay<?> overlay) {
        return overlay._getRoot();
    }

    public <Model> Model getModel() {
        JsonOverlay<?> model = this.overlay._getModel();
        return (Model)model;
    }

    public static <Model, V> Model getModel(JsonOverlay<V> overlay) {
        return new Overlay<V>(overlay).getModel();
    }

    public String getPathFromRoot() {
        return this.overlay._getPathFromRoot();
    }

    public static String getPathFromFromRoot(JsonOverlay<?> overlay) {
        return overlay._getPathFromRoot();
    }

    public String getJsonReference() {
        return this.overlay._getJsonReference();
    }

    public static String getJsonReference(JsonOverlay<?> overlay) {
        return overlay._getJsonReference();
    }

    public String getJsonReference(boolean forRef) {
        return this.overlay._getJsonReference(forRef);
    }

    public static String getJsonReference(JsonOverlay<?> overlay, boolean forRef) {
        return overlay._getJsonReference(forRef);
    }

    public Optional<PositionInfo> getPositionInfo() {
        return this.overlay._getPositionInfo();
    }

    public static Optional<PositionInfo> getPositionInfo(JsonOverlay<?> overlay) {
        return overlay._getPositionInfo();
    }

    public Optional<PositionInfo.PositionEndpoint> getStartPosition() {
        return this.overlay._getPositionInfo().map(info -> info.getStart());
    }

    public static Optional<PositionInfo.PositionEndpoint> getStartPosition(JsonOverlay<?> overlay) {
        return overlay._getPositionInfo().map(info -> info.getStart());
    }

    public List<String> getPropertyNames() {
        if (this.overlay instanceof PropertiesOverlay) {
            return ((PropertiesOverlay)this.overlay)._getPropertyNames();
        }
        return null;
    }

    public static <V> List<String> getPropertyNames(JsonOverlay<V> overlay) {
        return new Overlay<V>(overlay).getPropertyNames();
    }

    public boolean isReference(String key) {
        return this.getReference(key) != null;
    }

    public static <V> boolean isReference(JsonOverlay<V> overlay, String key) {
        return new Overlay<V>(overlay).isReference(key);
    }

    public boolean isReference(int index) {
        return this.getReference(index) != null;
    }

    public static <V> boolean isReference(JsonOverlay<V> overlay, int index) {
        return new Overlay<V>(overlay).getReference(index) != null;
    }

    public Overlay<V> getReferenceOverlay() {
        RefOverlay<V> refOverlay = this.overlay._getRefOverlay();
        return refOverlay != null ? new Overlay<V>(refOverlay.getOverlay()) : null;
    }

    public static <V> Overlay<V> getReferenceOverlay(JsonOverlay<V> overlay) {
        return Overlay.of(overlay).getReferenceOverlay();
    }

    public Reference getReference(String key) {
        if (this.overlay instanceof PropertiesOverlay) {
            return this.getPropertyReference(key);
        }
        if (this.overlay instanceof MapOverlay) {
            return this.getMapReference(key);
        }
        return null;
    }

    public static <V> Reference getReference(JsonOverlay<V> overlay, String key) {
        return new Overlay<V>(overlay).getReference(key);
    }

    public Reference getReference(int index) {
        if (this.overlay instanceof ListOverlay) {
            return this.getListReference(index);
        }
        return null;
    }

    public static <V> Reference getReference(JsonOverlay<V> overlay, int index) {
        return new Overlay<V>(overlay).getReference(index);
    }

    private Reference getPropertyReference(String name) {
        PropertiesOverlay propsOverlay = (PropertiesOverlay)this.overlay;
        return this.getReference(propsOverlay._getOverlay(name));
    }

    private Reference getMapReference(String key) {
        MapOverlay mapOverlay = (MapOverlay)this.overlay;
        return this.getReference(mapOverlay._getOverlay(key));
    }

    private Reference getListReference(int index) {
        ListOverlay listOverlay = (ListOverlay)this.overlay;
        return this.getReference(listOverlay._getOverlay(index));
    }

    private Reference getReference(JsonOverlay<?> overlay) {
        return overlay != null ? overlay._getReference() : null;
    }

    private static <X> ListOverlay<X> getSidebandOverlay(List<X> list) {
        try {
            ListOverlay castOverlay = (ListOverlay)list.getClass().getMethod("getOverlay", new Class[0]).invoke(list, new Object[0]);
            return castOverlay;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    private static <X> MapOverlay<X> getSidebandOverlay(Map<String, X> map) {
        try {
            MapOverlay castOverlay = (MapOverlay)map.getClass().getMethod("getOverlay", new Class[0]).invoke(map, new Object[0]);
            return castOverlay;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    public String toString() {
        return this.overlay.toString();
    }
}

