/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10.conformance;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.opengis.cite.ogcapitiles10.CommonFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class Tile
extends CommonFixture {
    private JsonPath response;
    private String tileMatrixTemplateString = "tileMatrix";
    private String tileRowTemplateString = "tileRow";
    private String tileColTemplateString = "tileCol";

    @Test(description="Implements Abstract test A.2, Requirement 1: /req/core/tc-op")
    public void validateTilesAreAvailable() throws Exception {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List links = this.response.getList("links");
        String resultString = "No tiles resource was found";
        for (Object linkObj : links) {
            Map link = (Map)linkObj;
            Object linkType = link.get("rel");
            ObjectMapper mapper = new ObjectMapper();
            if (!link.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-")) continue;
            resultString = this.processTilesResponse(link.get("href").toString(), false, false);
        }
        if (resultString.contains("No tiles resource was found")) {
            resultString = this.processNestedTilesResponse();
        }
        Assert.assertTrue((resultString.length() == 0 ? 1 : 0) != 0, (String)resultString);
    }

    @Test(description="Implements Abstract test A.6, Requirement 5: /req/core/tc-success")
    public void validateSuccessfulTilesExecutionFollowingLinks() throws Exception {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List links = this.response.getList("links");
        String resultString = "";
        for (Object linkObj : links) {
            Map link = (Map)linkObj;
            Object linkType = link.get("rel");
            ObjectMapper mapper = new ObjectMapper();
            if (!link.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-")) continue;
            resultString = this.processTilesResponse(link.get("href").toString(), true, false);
        }
        Assert.assertTrue((resultString.length() == 0 ? 1 : 0) != 0, (String)resultString);
    }

    @Test(description="Implements Abstract test A.7: /conf/core/tc-error, Requirement 6: /req/core/tc-error")
    public void validateTilesErrorConditions() throws Exception {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List links = this.response.getList("links");
        String resultString = "";
        for (Object linkObj : links) {
            Map link = (Map)linkObj;
            Object linkType = link.get("rel");
            ObjectMapper mapper = new ObjectMapper();
            if (!link.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-")) continue;
            resultString = this.processTilesResponse(link.get("href").toString(), true, true);
        }
        Assert.assertTrue((resultString.length() == 0 ? 1 : 0) != 0, (String)resultString);
    }

    @Test(description="Implements Abstract test A.3, Requirement 2: /req/core/tc-tilematrix-definition")
    public void validateTileMatrixDefinitionIsAvailable() throws Exception {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List links = this.response.getList("links");
        boolean foundTemplates = false;
        for (int t = 0; t < links.size(); ++t) {
            Object linkObj = links.get(t);
            Map link = (Map)linkObj;
            Object linkType = link.get("rel");
            ObjectMapper mapper = new ObjectMapper();
            if (!link.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-")) continue;
            foundTemplates = this.findTemplateDefinition(link.get("href").toString(), this.tileMatrixTemplateString);
            t = links.size();
        }
        if (!foundTemplates) {
            foundTemplates = this.findNestedTemplateDefinition(this.tileMatrixTemplateString);
        }
        Assert.assertTrue((boolean)foundTemplates, (String)(this.tileMatrixTemplateString + " definition could not be found"));
    }

    private String processNestedTilesResponse() {
        StringBuffer errorMessages = new StringBuffer();
        Response request2 = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        ((ValidatableResponse)request2.then()).statusCode(200);
        this.response = request2.jsonPath();
        List collectionsList = this.response.getList("collections");
        boolean foundTilesetsLink = false;
        boolean nestedTilesAreAvailable = false;
        for (Object collectionObj : collectionsList) {
            HashMap collection = (HashMap)collectionObj;
            ArrayList collectionLinks = (ArrayList)collection.get("links");
            for (int q = 0; q < collectionLinks.size(); ++q) {
                HashMap linkItem = (HashMap)collectionLinks.get(q);
                if (!linkItem.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-") || foundTilesetsLink) continue;
                String newURL = this.formatLinkURI(this.rootUri.getScheme(), this.rootUri.getHost(), linkItem.get("href").toString());
                Response tilesRequest = (Response)this.init().baseUri(newURL).accept(ContentType.JSON).when().request(Method.GET);
                ((ValidatableResponse)tilesRequest.then()).statusCode(200);
                JsonPath tilesResponse = tilesRequest.jsonPath();
                List tilesetsList = tilesResponse.getList("tilesets");
                for (int r = 0; r < tilesetsList.size(); ++r) {
                    HashMap tileset = (HashMap)tilesetsList.get(r);
                    ArrayList tilesetLinksList = (ArrayList)tileset.get("links");
                    for (int p = 0; p < tilesetLinksList.size(); ++p) {
                        HashMap tilesetLink = (HashMap)tilesetLinksList.get(p);
                        if (!tilesetLink.containsKey("rel") || !tilesetLink.containsKey("type") || !tilesetLink.get("rel").toString().equals("self") || !tilesetLink.get("type").toString().equals("application/json")) continue;
                        String newURL2 = this.formatLinkURI(this.rootUri.getScheme(), this.rootUri.getHost(), tilesetLink.get("href").toString());
                        Response innerTilesRequest = (Response)this.init().baseUri(newURL2).accept(ContentType.JSON).when().request(Method.GET);
                        ((ValidatableResponse)innerTilesRequest.then()).statusCode(200);
                        JsonPath innerTilesResponse = innerTilesRequest.jsonPath();
                        List innerTilesLinks = innerTilesResponse.getList("links");
                        for (int x = 0; x < innerTilesLinks.size(); ++x) {
                            HashMap innerTileLink = (HashMap)innerTilesLinks.get(x);
                            nestedTilesAreAvailable = true;
                        }
                    }
                }
                foundTilesetsLink = true;
            }
        }
        errorMessages.append(nestedTilesAreAvailable ? "" : "No tiles resource found in collections");
        return errorMessages.toString();
    }

    private boolean findNestedTemplateDefinition(String definitionTemplate) {
        boolean foundTemplates = false;
        Response request2 = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        ((ValidatableResponse)request2.then()).statusCode(200);
        this.response = request2.jsonPath();
        List collectionsList = this.response.getList("collections");
        boolean foundTilesetsLink = false;
        for (Object collectionObj : collectionsList) {
            HashMap collection = (HashMap)collectionObj;
            ArrayList collectionLinks = (ArrayList)collection.get("links");
            for (int q = 0; q < collectionLinks.size(); ++q) {
                HashMap linkItem = (HashMap)collectionLinks.get(q);
                if (!linkItem.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-") || foundTilesetsLink) continue;
                String newURL = this.formatLinkURI(this.rootUri.getScheme(), this.rootUri.getHost(), linkItem.get("href").toString());
                Response tilesRequest = (Response)this.init().baseUri(newURL).accept(ContentType.JSON).when().request(Method.GET);
                ((ValidatableResponse)tilesRequest.then()).statusCode(200);
                JsonPath tilesResponse = tilesRequest.jsonPath();
                List tilesetsList = tilesResponse.getList("tilesets");
                for (int r = 0; r < tilesetsList.size(); ++r) {
                    HashMap tileset = (HashMap)tilesetsList.get(r);
                    ArrayList tilesetLinksList = (ArrayList)tileset.get("links");
                    for (int p = 0; p < tilesetLinksList.size(); ++p) {
                        HashMap tilesetLink = (HashMap)tilesetLinksList.get(p);
                        if (!tilesetLink.containsKey("rel") || !tilesetLink.containsKey("type") || !tilesetLink.get("rel").toString().equals("self") || !tilesetLink.get("type").toString().equals("application/json")) continue;
                        String newURL2 = this.formatLinkURI(this.rootUri.getScheme(), this.rootUri.getHost(), tilesetLink.get("href").toString());
                        Response innerTilesRequest = (Response)this.init().baseUri(newURL2).accept(ContentType.JSON).when().request(Method.GET);
                        ((ValidatableResponse)innerTilesRequest.then()).statusCode(200);
                        JsonPath innerTilesResponse = innerTilesRequest.jsonPath();
                        List innerTilesLinks = innerTilesResponse.getList("links");
                        for (int x = 0; x < innerTilesLinks.size(); ++x) {
                            HashMap innerTileLink = (HashMap)innerTilesLinks.get(x);
                            if (!innerTileLink.get("href").toString().contains("{" + definitionTemplate + "}")) continue;
                            foundTemplates = true;
                        }
                    }
                }
                foundTilesetsLink = true;
            }
        }
        return foundTemplates;
    }

    @Test(description="Implements Abstract test A.4, Requirement 3: /req/core/tc-tilerow-definition")
    public void validateTileRowDefinitionIsAvailable() throws Exception {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List links = this.response.getList("links");
        boolean foundTemplates = false;
        for (int t = 0; t < links.size(); ++t) {
            Object linkObj = links.get(t);
            Map link = (Map)linkObj;
            Object linkType = link.get("rel");
            ObjectMapper mapper = new ObjectMapper();
            if (!link.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-")) continue;
            foundTemplates = this.findTemplateDefinition(link.get("href").toString(), this.tileRowTemplateString);
            t = links.size();
        }
        if (!foundTemplates) {
            foundTemplates = this.findNestedTemplateDefinition(this.tileRowTemplateString);
        }
        Assert.assertTrue((boolean)foundTemplates, (String)(this.tileRowTemplateString + " definition could not be found"));
    }

    @Test(description="Implements Abstract test A.5, Requirement 4: /req/core/tc-tilecol-definition")
    public void validateTileColDefinitionIsAvailable() throws Exception {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List links = this.response.getList("links");
        boolean foundTemplates = false;
        for (int t = 0; t < links.size(); ++t) {
            Object linkObj = links.get(t);
            Map link = (Map)linkObj;
            Object linkType = link.get("rel");
            ObjectMapper mapper = new ObjectMapper();
            if (!link.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-")) continue;
            foundTemplates = this.findTemplateDefinition(link.get("href").toString(), this.tileColTemplateString);
            t = links.size();
        }
        if (!foundTemplates) {
            foundTemplates = this.findNestedTemplateDefinition(this.tileColTemplateString);
        }
        Assert.assertTrue((boolean)foundTemplates, (String)(this.tileColTemplateString + " definition could not be found"));
    }

    private boolean findTemplateDefinition(String urlString, String definitionTemplate) {
        boolean foundTemplates = false;
        Response request = (Response)this.init().baseUri(urlString).accept(ContentType.JSON).when().request(Method.GET);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List tilesets = this.response.getList("tilesets");
        for (Object tilesetObj : tilesets) {
            Map tileset = (Map)tilesetObj;
            ArrayList linksList = (ArrayList)tileset.get("links");
            for (int i = 0; i < linksList.size(); ++i) {
                HashMap links = (HashMap)linksList.get(i);
                try {
                    if (!links.get("href").toString().contains("{" + definitionTemplate + "}")) continue;
                    foundTemplates = true;
                    continue;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        return foundTemplates;
    }

    private String processTilesResponse(String urlString, boolean testURL, boolean checkErrorResponse) {
        StringBuffer errorMessages = new StringBuffer();
        boolean foundTemplates = false;
        Response request = (Response)this.init().baseUri(urlString).accept(ContentType.JSON).when().request(Method.GET);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List tilesets = this.response.getList("tilesets");
        for (Object tilesetObj : tilesets) {
            int i;
            Map tileset = (Map)tilesetObj;
            String tileMatrixSetId = tileset.get("tileMatrixSetId").toString();
            ArrayList linksList = (ArrayList)tileset.get("links");
            ArrayList tileMatrixSetLimitsList = (ArrayList)tileset.get("tileMatrixSetLimits");
            String tileMatrix = "";
            String maxTileRow = "";
            String minTileCol = "";
            for (i = 0; i < Math.min(tileMatrixSetLimitsList.size(), 1); ++i) {
                HashMap tileMatrixSetLimits = (HashMap)tileMatrixSetLimitsList.get(i);
                tileMatrix = tileMatrixSetLimits.get("tileMatrix").toString();
                maxTileRow = tileMatrixSetLimits.get("maxTileRow").toString();
                minTileCol = tileMatrixSetLimits.get("minTileCol").toString();
            }
            for (i = 0; i < linksList.size(); ++i) {
                HashMap links = (HashMap)linksList.get(i);
                try {
                    if (!links.get("href").toString().contains("{" + this.tileMatrixTemplateString + "}") || !links.get("href").toString().contains("{" + this.tileRowTemplateString + "}") || !links.get("href").toString().contains("{" + this.tileColTemplateString + "}")) continue;
                    if (testURL) {
                        int responseCode;
                        HttpURLConnection httpConn;
                        URL urlStr;
                        String newURL;
                        if (!checkErrorResponse) {
                            newURL = links.get("href").toString().replace("{" + this.tileMatrixTemplateString + "}", tileMatrix).replace("{" + this.tileRowTemplateString + "}", maxTileRow).replace("{" + this.tileColTemplateString + "}", minTileCol);
                            urlStr = new URL(newURL);
                            httpConn = (HttpURLConnection)urlStr.openConnection();
                            responseCode = httpConn.getResponseCode();
                            if (responseCode != 200) {
                                errorMessages.append("Expected status code 200 but received " + responseCode + " . ");
                            }
                        } else if (checkErrorResponse && (responseCode = (httpConn = (HttpURLConnection)(urlStr = new URL(newURL = links.get("href").toString().replace("{" + this.tileMatrixTemplateString + "}", tileMatrix).replace("{" + this.tileRowTemplateString + "}", "" + (Integer.parseInt(maxTileRow) + 1)).replace("{" + this.tileColTemplateString + "}", minTileCol))).openConnection()).getResponseCode()) != 404 && responseCode != 400) {
                            errorMessages.append("Expected status code 404 or 400 but received " + responseCode + " . ");
                        }
                    }
                    foundTemplates = true;
                    continue;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        if (!foundTemplates) {
            errorMessages.append("No URL templates were found.");
        }
        return errorMessages.toString();
    }

    private String parseTilesetMetadata(String urlString) {
        String tileSetMetadata = null;
        try {
            tileSetMetadata = this.readJSONObjectFromURL(new URL(urlString));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tileSetMetadata;
    }

    public String readJSONObjectFromURL(URL requestURL) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)requestURL.openConnection();
        urlConnection.setRequestProperty("Accept", "application/json");
        InputStream is = urlConnection.getInputStream();
        try (Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }
}

