/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10.tilesetslist;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapitiles10.CommonFixture;
import org.opengis.cite.ogcapitiles10.SuiteAttribute;
import org.opengis.cite.ogcapitiles10.conformance.RequirementClass;
import org.opengis.cite.ogcapitiles10.openapi3.TestPoint;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TilesetLlinks
extends CommonFixture {
    private JsonPath response;

    @DataProvider(name="tilesetListsURIs")
    public Object[][] tilesetUris(ITestContext testContext) {
        OpenApi3 apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
        URI iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
        TestPoint tp = new TestPoint(this.rootUri.toString(), "/collections", null);
        ArrayList<TestPoint> testPoints = new ArrayList<TestPoint>();
        testPoints.add(tp);
        Object[][] testPointsData = new Object[1][];
        int i = 0;
        for (TestPoint testPoint : testPoints) {
            testPointsData[i++] = new Object[]{testPoint};
        }
        return testPointsData;
    }

    @Test(description="Implements Abstract test A.9, addresses Requirement 10 (/req/tilesets-list/tileset-links)", groups={"tilesetsLists"}, dataProvider="tilesetListsURIs")
    public void validateTilesetsListResponse(ITestContext testContext, TestPoint testPoint) {
        if (this.rootUri == null) {
            throw new SkipException("Skipped because a Landing Page was not provided");
        }
        Object requirementsClassesObject = testContext.getSuite().getAttribute(SuiteAttribute.REQUIREMENTCLASSES.getName());
        boolean implementsGeoDataTilesets = false;
        if (requirementsClassesObject instanceof List) {
            List requirementsClassesList = (List)requirementsClassesObject;
            if (!requirementsClassesList.contains((Object)RequirementClass.TILESETS_LIST)) {
                throw new SkipException(this.tilesets_lists_conformance_class_not_implemented);
            }
            if (requirementsClassesList.contains((Object)RequirementClass.GEODATA_TILESETS)) {
                implementsGeoDataTilesets = true;
            }
        }
        StringBuffer errorMessagesRoot = new StringBuffer();
        StringBuffer errorMessagesCollection = new StringBuffer();
        errorMessagesRoot.append(this.tilesetsListResponseFromRoot());
        if (implementsGeoDataTilesets) {
            errorMessagesCollection.append(this.tilesetsListResponseFromCollections());
        }
        Assert.assertTrue((errorMessagesRoot.toString().length() == 0 && errorMessagesCollection.toString().length() == 0 ? 1 : 0) != 0, (String)(errorMessagesRoot.toString() + " \n" + errorMessagesCollection.toString()));
    }

    private String tilesetsListResponseFromRoot() {
        StringBuffer errorMessages = new StringBuffer();
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
        List links = this.response.getList("links");
        boolean hasTilesets = false;
        for (Object linkObj : links) {
            boolean hasSubsetOfTheTilesetMetadata;
            Map link = (Map)linkObj;
            Object linkType = link.get("rel");
            if (!link.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-")) continue;
            if (link.get("href").toString().contains("f=json") && !(hasSubsetOfTheTilesetMetadata = this.checkHasSubsetOfTheTilesetMetadata(link.get("href").toString()))) {
                errorMessages.append("One of the tilesets did not have the minimum required subset of metadata ;");
            }
            if (link.get("href").toString().contains("/tiles")) continue;
            errorMessages.append("'/tiles' path not found at link relation type " + link.get("href").toString() + " ;");
        }
        return errorMessages.toString();
    }

    private String tilesetsListResponseFromCollections() {
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        JsonPath response = request.jsonPath();
        List collections = response.getList("collections");
        StringBuffer errorMessages = new StringBuffer();
        int tilesCollectionLimit = 2;
        int tilesCollectionCount = 0;
        for (int a = 0; a < collections.size() && tilesCollectionCount < tilesCollectionLimit; ++a) {
            HashMap collection = (HashMap)collections.get(a);
            ArrayList links = (ArrayList)collection.get("links");
            for (int b = 0; b < links.size(); ++b) {
                HashMap link = (HashMap)links.get(b);
                if (!link.get("rel").toString().startsWith("http://www.opengis.net/def/rel/ogc/1.0/tilesets-")) continue;
                if (link.get("href").toString().contains("f=json")) {
                    boolean hasSubsetOfTheTilesetMetadata = this.checkHasSubsetOfTheTilesetMetadata(link.get("href").toString());
                    if (!hasSubsetOfTheTilesetMetadata) {
                        errorMessages.append("One of the tilesets in " + collection.get("title") + " did not have the minimum required subset of metadata ;");
                    }
                    ++tilesCollectionCount;
                }
                if (link.get("href").toString().contains("/tiles")) continue;
                errorMessages.append("'/tiles' link relation not found in " + collection.get("title") + " ;");
            }
        }
        return errorMessages.toString();
    }

    private boolean checkHasSubsetOfTheTilesetMetadata(String href) {
        boolean hasSubsetOfTheTilesetMetadata = true;
        try {
            String newHref = href;
            if (href.startsWith("/")) {
                String[] hrefSegments = href.split("/");
                String token = this.rootUri.toString();
                newHref = token.replace("/" + hrefSegments[1], "");
                newHref = newHref.endsWith("/") ? newHref.substring(0, newHref.length() - 1) + href : newHref + href;
            }
            Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, newHref, new Object[0]);
            ((ValidatableResponse)request.then()).statusCode(200);
            JsonPath response = request.jsonPath();
            ArrayList tilesets = (ArrayList)response.getList("tilesets");
            for (int b = 0; b < tilesets.size(); ++b) {
                HashMap tilesetMap = (HashMap)tilesets.get(b);
                if (tilesetMap.containsKey("tileMatrixSetURI")) continue;
                hasSubsetOfTheTilesetMetadata = false;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return hasSubsetOfTheTilesetMetadata;
    }
}

