/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapitiles10.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.opengis.cite.ogcapitiles10.ReusableEntityFilter;
import org.w3c.dom.Document;

public class ClientUtils {
    public static Client buildClient() {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.followRedirects", (Object)true);
        config.property("jersey.config.client.connectTimeout", (Object)10000);
        Client client = ClientBuilder.newClient((Configuration)config);
        client.register((Object)new ReusableEntityFilter());
        return client;
    }

    public static Client buildClientWithProxy(String proxyHost, int proxyPort) {
        ClientConfig config = new ClientConfig();
        config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
        config.property("jersey.config.client.proxy.uri", (Object)proxy);
        config.property("jersey.config.client.followRedirects", (Object)true);
        Client client = ClientBuilder.newClient((Configuration)config);
        client.register((Object)new ReusableEntityFilter());
        return client;
    }

    public static MediaType removeParameters(MediaType mediaType) {
        return new MediaType(mediaType.getType(), mediaType.getSubtype());
    }

    public static Source getResponseEntityAsSource(ClientResponse response, String targetURI) {
        Source source = (Source)response.readEntity(DOMSource.class);
        if (null != targetURI && !targetURI.isEmpty()) {
            source.setSystemId(targetURI);
        }
        if (response.getEntityStream().markSupported()) {
            try {
                response.getEntityStream().reset();
            }
            catch (IOException ex) {
                Logger.getLogger(ClientUtils.class.getName()).log(Level.WARNING, "Failed to reset response entity.", ex);
            }
        }
        return source;
    }

    public static Document getResponseEntityAsDocument(ClientResponse response, String targetURI) {
        DOMSource domSource = (DOMSource)ClientUtils.getResponseEntityAsSource(response, targetURI);
        Document entityDoc = (Document)domSource.getNode();
        entityDoc.setDocumentURI(domSource.getSystemId());
        return entityDoc;
    }

    public static boolean is200Response(URI uri) {
        URL url = null;
        int code = 0;
        try {
            url = uri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            code = connection.getResponseCode();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return code == 200;
    }
}

