/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.om20.level1;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.om20.ETSAssert;
import org.opengis.cite.om20.level1.DataFixture;
import org.opengis.cite.om20.util.NamespaceBindings;
import org.opengis.cite.om20.util.ValidationUtils;
import org.opengis.cite.om20.util.XMLUtils;
import org.opengis.cite.validation.XmlSchemaCompiler;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class GenericObservationDataValidation
extends DataFixture {
    private final String observation_type_measurement = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement";
    private final String observation_type_category = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation";
    private final String observation_type_count = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation";
    private final String observation_type_truth = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TruthObservation";
    private final String observation_type_complex = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ComplexObservation";
    private final String observation_type_geometry = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_GeometryObservation";
    private final String observation_type_temporal = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TemporalObservation";
    private final String observation_type_swe_simple = "http://www.opengis.net/def/observationType/OGC-OM/2.0/SWEScalarObservation";
    private final String observation_type_swe_array = "http://www.opengis.net/def/observationType/OGC-OM/2.0/SWEArrayObservation";

    @Test(groups={"A.1. Generic observation data - by various Schema References"}, description="Validate the XML document using the XML schema document observation.xsd")
    public void ObservationValidation() {
        URL entityCatalog = this.getClass().getResource("/org/opengis/cite/om20/xsd/opengis/om/2.0/observation.xsd");
        DOMSource source = new DOMSource(this.testSubject);
        try {
            Validator validator = this.CreateValidator(entityCatalog);
            ETSAssert.assertSchemaValid(validator, source);
        }
        catch (IOException | XMLStreamException | SAXException e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.2 Conformance class: Measurement data"}, description="Verify that the XML element om:result has a value that matches the content model defined by gml:MeasureType")
    public void MeasurementData() {
        String hasResultTime = this.CheckXPath2("boolean(//om:resultTime)");
        if (hasResultTime.equals("false")) {
            throw new SkipException("Not measurement data.");
        }
        List<String> href = this.GetResultTypeHref();
        if (!href.contains(this.observation_type_measurement)) {
            throw new SkipException("Not measurement data.");
        }
        try {
            List<String> results = this.CheckObservationTypeMeasurement(this.observation_type_measurement);
            if (results.contains("false")) {
                Assert.assertTrue(false, "XML element om:result has a value that matches the content model defined by gml:MeasureType.");
            } else {
                Assert.assertTrue(true, "XML element om:result has a value that matches the content model defined by gml:MeasureType.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.3 Conformance class: Category observation data"}, description="Verify that the XML element om:result has a value that matches the content model defined by gml:ReferenceType")
    public void CategoryObservation() {
        String hasResultTime = this.CheckXPath2("boolean(//om:resultTime)");
        if (hasResultTime.equals("false")) {
            throw new SkipException("Not category observation.");
        }
        List<String> href = this.GetResultTypeHref();
        if (!href.contains(this.observation_type_category)) {
            throw new SkipException("Not category data.");
        }
        try {
            List<String> results = this.CheckObservationTypeCategory(this.observation_type_category);
            if (results.contains("false")) {
                Assert.assertTrue(false, "element om:result has a value that matches the content model defined by gml:ReferenceType.");
            } else {
                Assert.assertTrue(true, "element om:result has a value that matches the content model defined by gml:ReferenceType.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.4 Conformance class: Count observation data"}, description="Verify that the XML element om:result has a value that matches the content model defined by xs:integer.")
    public void CountObservation() {
        String hasResultTime = this.CheckXPath2("boolean(//om:resultTime)");
        if (hasResultTime.equals("false")) {
            throw new SkipException("Not count observation.");
        }
        List<String> href = this.GetResultTypeHref();
        if (!href.contains(this.observation_type_count)) {
            throw new SkipException("Not count data.");
        }
        try {
            List<String> results = this.CheckObservationTypeCount(this.observation_type_count);
            if (results.contains("false")) {
                Assert.assertTrue(false, "element om:result has a value that matches the content model defined by xs:integer.");
            } else {
                Assert.assertTrue(true, "element om:result has a value that matches the content model defined by xs:integer.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.5 Conformance class: Truth observation data"}, description="Verify that the XML element om:result has a value that matches the content model defined by xs:boolean.")
    public void TruthObservation() {
        String hasResultTime = this.CheckXPath2("boolean(//om:resultTime)");
        if (hasResultTime.equals("false")) {
            throw new SkipException("Not truth observation.");
        }
        List<String> href = this.GetResultTypeHref();
        if (!href.contains(this.observation_type_truth)) {
            throw new SkipException("Not truth data.");
        }
        try {
            List<String> results = this.CheckObservationTypeTruth(this.observation_type_truth);
            if (results.contains("false")) {
                Assert.assertTrue(false, "element om:result has a value that matches the content model defined by xs:boolean.");
            } else {
                Assert.assertTrue(true, "element om:result has a value that matches the content model defined by xs:boolean.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.6. Geometry observation data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/om/2.0/geometryObservation.sch")
    public void ResultGeometry() {
        List<String> href = this.GetResultTypeHref();
        if (!href.contains(this.observation_type_geometry)) {
            throw new SkipException("Not geometry data.");
        }
        String candidateNode = this.CheckXPath2("//om:result/*[1]/name()");
        String nodeName = "gml:AbstractGeometry";
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_GML_Path);
            String result = this.SchemaElement(candidateNode, nodeName, schemaFile);
            Assert.assertTrue(result.equals("true"), "XML element om:result must contains a sub-element in the substitution group of gml:AbstractGeometry.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> GetResultTypeHref() {
        int count_observation = Integer.parseInt(this.CheckXPath2("count(//om:OM_Observation/om:type/@xlink:href)"));
        ArrayList<String> list_href = new ArrayList<String>();
        for (int i = 1; i <= count_observation; ++i) {
            list_href.add(this.CheckXPath2(String.format("string((//om:OM_Observation/om:type/@xlink:href)[%s])", i)));
        }
        return list_href;
    }

    @Test(groups={"A.7. Temporal observation data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/om/2.0/temporalObservation.sch")
    public void ResultTimeObject() {
        List<String> href = this.GetResultTypeHref();
        if (!href.contains(this.observation_type_temporal)) {
            throw new SkipException("Not temporal data.");
        }
        String candidateNode = this.CheckXPath2("//om:result/*[1]/name()");
        String nodeName = "gml:AbstractTimeObject";
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_GML_Path);
            String result = this.SchemaElement(candidateNode, nodeName, schemaFile);
            Assert.assertTrue(result.equals("true"), "XML element om:result must contains a sub-element in the substitution group of gml:AbstractTimeObject.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.8. Complex observation data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/om/2.0/complexObservation.sch.")
    public void ResultSWErecord() {
        List<String> href = this.GetResultTypeHref();
        if (!href.contains(this.observation_type_complex)) {
            throw new SkipException("Not complex data.");
        }
        String candidateNode = this.CheckXPath2("//om:result/*[1]/name()");
        String nodeName_1 = "swe:DataRecord";
        String nodeName_2 = "swe:Vector";
        String result = "";
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_SWE_Path);
            String result_nodeName_1 = this.SchemaElement(candidateNode, nodeName_1, schemaFile);
            String result_nodeName_2 = this.SchemaElement(candidateNode, nodeName_2, schemaFile);
            result = result_nodeName_1.equals("true") || result_nodeName_2.equals("true") ? "true" : "false";
            Assert.assertTrue(result.equals("true"), "result must contain an element in the substitution group headed by swe:DataRecord or swe:Vector.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.9. SWE scalar observation data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/om/2.0/SWEScalarObservation.sch")
    public void ResultSWEscalar() {
        List<String> href = this.GetResultTypeHref();
        if (!href.contains(this.observation_type_swe_simple)) {
            throw new SkipException("Not SWE scalar observation.");
        }
        String candidateNode = this.CheckXPath2("//om:result/*[1]/name()");
        String inline_value = this.CheckXPath2("boolean(//om:result/*[1]/swe:value)");
        String nodeName = "swe:AbstractSimpleComponent";
        String final_result = "";
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_SWE_Path);
            String result = this.SchemaElement(candidateNode, nodeName, schemaFile);
            final_result = result.equals("true") && inline_value.equals("true") ? "true" : "false";
            Assert.assertTrue(final_result.equals("true"), "XML element om:result must contain an element in the substitution group headed by swe:AbstractSimpleComponent with an inline value.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.10. SWE array observation data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/om/2.0/SWEArrayObservation.sch")
    public void ResultSWEBlock() {
        List<String> href = this.GetResultTypeHref();
        if (!href.contains(this.observation_type_swe_array)) {
            throw new SkipException("Not SWE array observation.");
        }
        String candidateNode = this.CheckXPath2("//om:result/*[1]/name()");
        String nodeName_1 = "swe:DataArray";
        String nodeName_2 = "swe:Matrix";
        String nodeName_3 = "swe:DataStream";
        String inline_value = this.CheckXPath2("boolean(//om:result/*[1]/swe:values)");
        String final_result = "";
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_SWE_Path);
            String result_1 = this.SchemaElement(candidateNode, nodeName_1, schemaFile);
            String result_2 = this.SchemaElement(candidateNode, nodeName_2, schemaFile);
            String result_3 = this.SchemaElement(candidateNode, nodeName_3, schemaFile);
            final_result = (result_1.equals("true") || result_2.equals("true") || result_3.equals("true")) && inline_value.equals("true") ? "true" : "false";
            Assert.assertTrue(final_result.equals("true"), "result must contain an element in the substitution group headed by swe:DataArray, swe:Matrix or swe:DataStream and with inline values.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.11. Spatial observation data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/om/2.0/spatialObservation.sch")
    public void SpatialParameter() {
        if (this.CheckXPath2("boolean(//*[om:resultTime]/om:parameter)").equals("false")) {
            throw new SkipException("Not Spatial observation data.");
        }
        if (this.CheckXPath2("boolean(//om:parameter/om:NamedValue/om:name[@xlink:href = 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry'] | /om:parameter/om:NamedValue[om:name/@xlink:href= 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry'])").equals("false")) {
            throw new SkipException("Not Spatial observation data.");
        }
        String result_1 = "true";
        String xpath_rule1 = "count(//om:parameter/om:NamedValue/om:name[@xlink:href = 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry']) = 1";
        if (this.CheckXPath2(xpath_rule1).equals("false")) {
            result_1 = "false";
        }
        String result_2 = "true";
        String xpath_rule2 = "//*[om:resultTime]/om:parameter/om:NamedValue[om:name/@xlink:href= 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry']/om:value/*[1]/name()";
        String candidateNode = this.CheckXPath2(xpath_rule2);
        String nodeName = "gml:AbstractGeometry";
        if (candidateNode.contains("XdmEmptySequence")) {
            result_2 = "false";
        } else {
            try {
                File schemaFile = this.GetFileViaResourcePath(this.Resource_GML_Path);
                result_2 = this.SchemaElement(candidateNode, nodeName, schemaFile);
            }
            catch (SaxonApiException e) {
                e.printStackTrace();
            }
        }
        String final_result = "";
        final_result = result_1.equals("true") && result_2.equals("true") ? "true" : "false";
        Assert.assertTrue(final_result.equals("true"), "A spatial observation MUST have exactly one sampling geometry encoded as XML element om:parameter in an observation.\tThe xlink:href attribute in the XML element om:name of the om:parameter/om:NamedValue element that \tcarries the sampling geometry MUST have the value 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry'. \tAnd, the XML element om:value in the om:parameter/om:NamedValue element which carries the sampling \tgeometry MUST have a value of type gml:AbstractGeometry");
    }

    @Test(groups={"A.12. Sampling feature data"}, description="Validate the XML document using the XML schema document http://schemas.opengis.net/sampling/2.0/samplingFeature.xsd")
    public void SamplingValid() {
        if (this.CheckXPath2("boolean(//sam:SF_SamplingFeature)").equals("false")) {
            throw new SkipException("Not Sampling feature data.");
        }
        URL entityCatalog = this.getClass().getResource("/org/opengis/cite/om20/xsd/opengis/om/2.0/samplingFeature.xsd");
        Validator validator = null;
        try {
            validator = this.CreateValidator(entityCatalog);
        }
        catch (IOException | XMLStreamException | SAXException e) {
            e.printStackTrace();
        }
        DOMSource source = new DOMSource(this.testSubject);
        ETSAssert.assertSchemaValid(validator, source);
    }

    @Test(groups={"A.13. Spatial Sampling feature data"}, description="Validate the XML document using the XML schema document http://schemas.opengis.net/samplingSpatial/2.0/spatialSamplingFeature.xsd")
    public void SpatialSamplingValid() {
        if (this.CheckXPath2("boolean(//sams:SF_SpatialSamplingFeature)").equals("true")) {
            URL entityCatalog = this.getClass().getResource("/org/opengis/cite/om20/xsd/opengis/om/2.0/spatialSamplingFeature.xsd");
            try {
                Validator validator = this.CreateValidator(entityCatalog);
                DOMSource source = new DOMSource(this.testSubject);
                ETSAssert.assertSchemaValid(validator, source);
            }
            catch (IOException | XMLStreamException | SAXException e) {
                e.printStackTrace();
            }
        } else {
            throw new SkipException("Not Spatial Sampling feature data.");
        }
    }

    @Test(groups={"A.13. Spatial Sampling feature data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/samplingSpatial/2.0/shapeTypeConsistent.sch")
    public void ShapeTypeConsistent() {
        if (this.CheckXPath2("boolean(//sams:SF_SpatialSamplingFeature)").equals("false")) {
            throw new SkipException("Not Spatial Sampling feature data.");
        }
        String sampling_feature_type_point = "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint";
        String sampling_feature_type_curve = "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve";
        String sampling_feature_type_surface = "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface";
        String sampling_feature_type_solid = "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSolid";
        String href = this.CheckXPath2("string(//sams:SF_SpatialSamplingFeature/sam:type/@xlink:href)");
        if (href.equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint")) {
            String final_result = this.testA13("gml:Point");
            Assert.assertTrue(final_result.equals("true"), "a member of the substitution group headed by gml:Point or an xlink must be present as child of sams:shape");
        } else if (href.equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve")) {
            String final_result = this.testA13("gml:AbstractCurve");
            Assert.assertTrue(final_result.equals("true"), "a member of the substitution group headed by gml:Curve or an xlink must be present as child of sams:shape");
        } else if (href.equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface")) {
            String final_result = this.testA13("gml:AbstractSurface");
            Assert.assertTrue(final_result.equals("true"), "a member of the substitution group headed by gml:AbstractSurface or an xlink must be present as child of sams:shape");
        } else if (href.equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSolid")) {
            String final_result = this.testA13("gml:AbstractSolid");
            Assert.assertTrue(final_result.equals("true"), "a member of the substitution group headed by gml:AbstractSolid or an xlink must be present as child of sams:shape");
        } else {
            String final_result = "false";
            Assert.assertTrue(final_result.equals("true"), "Invalid xlink:href attribute of sam:type element");
        }
    }

    private String testA13(String schema_element_Value) {
        String result_1 = "";
        String candidateNode = this.CheckXPath2("//sams:SF_SpatialSamplingFeature/sams:shape/*[1]/name()");
        String nodeName = schema_element_Value;
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_GML_Path);
            result_1 = this.SchemaElement(candidateNode, nodeName, schemaFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result_2 = this.CheckXPath2("boolean(//sams:SF_SpatialSamplingFeature/sams:shape/@xlink:href)");
        String final_result = "";
        final_result = result_1.equals("true") || result_2.equals("true") ? "true" : "false";
        return final_result;
    }

    @Test(groups={"A.18. Specimen data"}, description="Validate the XML document using the XML Schema document http://schemas.opengis.net/samplingSpecimen/2.0/specimen.xsd")
    public void SpecimenValid() {
        if (this.CheckXPath2("boolean(//spec:SF_Specimen)").equals("false")) {
            throw new SkipException("Not Specimen data.");
        }
        URL entityCatalog = this.getClass().getResource("/org/opengis/cite/om20/xsd/opengis/om/2.0/specimen.xsd");
        Validator validator = null;
        try {
            validator = this.CreateValidator(entityCatalog);
        }
        catch (IOException | XMLStreamException | SAXException e) {
            e.printStackTrace();
        }
        DOMSource source = new DOMSource(this.testSubject);
        ETSAssert.assertSchemaValid(validator, source);
    }

    private File GetFileViaResourcePath(String resourcePath) {
        try {
            InputStream in = this.getClass().getResourceAsStream(resourcePath);
            if (in == null) {
                return null;
            }
            File tempFile = File.createTempFile(String.valueOf(in.hashCode()), ".tmp");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            return tempFile;
        }
        catch (IOException e) {
            URL xsdPath = this.getClass().getResource(resourcePath);
            File file = new File(xsdPath.toString().substring(5));
            return file;
        }
    }

    public Validator CreateValidator(URL xsdPath) throws XMLStreamException, SAXException, IOException {
        Set<URI> schemaRefs = ValidationUtils.extractSchemaReferences(new StreamSource(this.dataFile), this.testSubjectUri.toString());
        XmlSchemaCompiler xsdCompiler = new XmlSchemaCompiler(xsdPath);
        Schema schema = xsdCompiler.compileXmlSchema(schemaRefs.toArray(new URI[schemaRefs.size()]));
        return schema.newValidator();
    }

    public static XdmValue evaluateXPath2Modified(File xmlFile, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = builder.build(xmlFile);
        xpath.setContextItem(node);
        return xpath.evaluate();
    }

    public XdmValue CheckXPath2Modified(String xpath2, File xmlFile) {
        XdmValue xdmValue = null;
        try {
            xdmValue = GenericObservationDataValidation.evaluateXPath2Modified(xmlFile, xpath2, NamespaceBindings.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue;
    }

    public String SchemaElement(String candidateNode, String nodeName, File schemaFile) throws SaxonApiException {
        String xpath_t2_4;
        String test1_result = "true";
        if (candidateNode.equals(nodeName)) {
            String xpath_t1_1 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@abstract", nodeName.split(":")[1]);
            String bool_xpath_t1_1 = String.format("boolean(%s)", xpath_t1_1);
            if (this.CheckXPath2Modified(bool_xpath_t1_1, schemaFile).equals("true") && this.CheckXPath2Modified(xpath_t1_1, schemaFile).toString().split("=")[1].equals("\"true\"")) {
                test1_result = "false";
            }
        } else {
            String sub_name = "";
            String name = String.format("\"%s\"", candidateNode.split(":")[1]);
            while (true) {
                String xpath_t1_2;
                String result_xpath_t1_2;
                if ((result_xpath_t1_2 = this.CheckXPath2Modified(xpath_t1_2 = String.format("//xs:schema/xs:element[@name=%s]/@substitutionGroup", name), schemaFile).toString()).contains("XdmEmptySequence")) {
                    test1_result = "false";
                    break;
                }
                sub_name = result_xpath_t1_2.split("=")[1];
                if (sub_name.equals(String.format("\"%s\"", nodeName))) break;
                if (sub_name.equals("\"gml:AbstractGML\"") || sub_name.equals("\"gml:AbstractObject\"")) {
                    test1_result = "false";
                    break;
                }
                if (sub_name.equals("\"swe:AbstractSWE\"")) {
                    test1_result = "false";
                    break;
                }
                name = "\"".concat(sub_name.split(":")[1]);
            }
        }
        if (test1_result.equals("false")) {
            return "false";
        }
        String test2_result = "true";
        String xpath_t2_1 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@type", candidateNode.split(":")[1]);
        String candidateNode_type = this.CheckXPath2Modified(xpath_t2_1, schemaFile).toString();
        String xpath_t2_2 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@type", nodeName.split(":")[1]);
        String nodeName_type = this.CheckXPath2Modified(xpath_t2_2, schemaFile).toString();
        String xpath_t2_3 = String.format("boolean(//*[@name=%s])", String.format("\"%s", nodeName_type.split(":")[1]));
        if (this.CheckXPath2Modified(xpath_t2_3, schemaFile).equals("false")) {
            test2_result = "false";
        }
        if (this.CheckXPath2Modified(xpath_t2_4 = String.format("boolean(//*[@name=%s])", String.format("\"%s", candidateNode_type.split(":")[1])), schemaFile).equals("false")) {
            test2_result = "false";
        }
        if (!candidateNode_type.equals(nodeName_type)) {
            String type_element = "";
            String name_element = String.format("\"%s", candidateNode_type.split(":")[1]);
            while (true) {
                String xpath_t2_5 = String.format("//*[@name=%s]//@base", name_element);
                String result_xpath_t2_5 = "";
                if (this.CheckXPath2Modified(xpath_t2_5, schemaFile).size() > 1) {
                    result_xpath_t2_5 = this.CheckXPath2Modified(xpath_t2_5, schemaFile).itemAt(0).getStringValue();
                    type_element = String.format("\"%s\"", result_xpath_t2_5);
                } else if (this.CheckXPath2Modified(xpath_t2_5, schemaFile).size() == 1) {
                    result_xpath_t2_5 = this.CheckXPath2Modified(xpath_t2_5, schemaFile).toString();
                    type_element = result_xpath_t2_5.split("=")[1];
                } else {
                    test2_result = "false";
                    break;
                }
                if (type_element.equals(String.format("%s", nodeName_type.split("=")[1]))) break;
                if (type_element.equals("\"gml:AbstractGMLType\"")) {
                    test2_result = "false";
                    break;
                }
                name_element = "\"".concat(type_element.split(":")[1]);
            }
        }
        if (test2_result.equals("false")) {
            return "false";
        }
        String test3_result = "false";
        String xpath_t3_1 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@nillable", nodeName.split(":")[1]);
        String xpath_t3_2 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@nillable", candidateNode.split(":")[1]);
        String result_xpath_t3_1 = this.CheckXPath2Modified(xpath_t3_1, schemaFile).toString();
        String result_xpath_t3_2 = this.CheckXPath2Modified(xpath_t3_2, schemaFile).toString();
        if (result_xpath_t3_1.contains("XdmEmptySequence") && result_xpath_t3_2.contains("XdmEmptySequence")) {
            test3_result = "true";
        } else if (result_xpath_t3_1.equals(result_xpath_t3_2)) {
            test3_result = "true";
        }
        if (test3_result.equals("false")) {
            return "false";
        }
        String final_result = "";
        final_result = test1_result.equals("true") && test2_result.equals("true") && test3_result.equals("true") ? "true" : "false";
        return final_result;
    }

    public Validator CreateValidatorFromXSD(URL xsdPath) throws SAXException, IOException, URISyntaxException {
        XmlSchemaCompiler compiler = new XmlSchemaCompiler(xsdPath);
        Schema schema = compiler.compileXmlSchema(xsdPath.toURI());
        return schema.newValidator();
    }

    public String CheckXPath2(String xpath) {
        Object xdmValue = null;
        try {
            xdmValue = XMLUtils.evaluateXPath2(new DOMSource(this.testSubject), xpath, NamespaceBindings.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue.toString();
    }

    public List<String> CheckObservationTypeMeasurement(String href) {
        ArrayList<String> results = new ArrayList<String>();
        String context = String.format("//om:OM_Observation[om:type/@xlink:href='%s']", href);
        int count_observation = Integer.parseInt(this.CheckXPath2(String.format("count(%s)", context)));
        for (int i = 1; i <= count_observation; ++i) {
            String uom_value = String.format("(%s/om:result/@uom)[%s]", context, i);
            String result_text = String.format("(%s/om:result/text())[%s]", context, i);
            String xpath = String.format("(((%s castable as xs:string) and (string-length(%s) > 0) and (not(matches(%s, \"[: \\n\\r\\t]+\"))))  or ((%s castable as xs:anyURI) and matches(%s , \"([a-zA-Z][a-zA-Z0-9\\-\\+\\.]*:|\\.\\./|\\./|#).*\"))) and (%s castable as xs:double)", uom_value, uom_value, uom_value, uom_value, uom_value, result_text);
            results.add(this.CheckXPath2(xpath));
        }
        return results;
    }

    public List<String> CheckObservationTypeCategory(String href) {
        ArrayList<String> results = new ArrayList<String>();
        String context = String.format("//om:OM_Observation[om:type/@xlink:href='%s']", href);
        int count_observation = Integer.parseInt(this.CheckXPath2(String.format("count(%s)", context)));
        for (int i = 1; i <= count_observation; ++i) {
            boolean test1 = true;
            boolean test2 = false;
            if (this.CheckXPath2(String.format("(%s/om:result/@xlink:href)[%s]", context, i)).contains("XdmEmptySequence") || this.CheckXPath2(String.format("(%s/om:result/@xlink:title)[%s]", context, i)).contains("XdmEmptySequence")) {
                test1 = false;
            }
            if (this.CheckXPath2(String.format("(%s/om:result/*)[%s]", context, i)).contains("XdmEmptySequence") && this.CheckXPath2(String.format("(%s/om:result/text())[%s]", context, i)).contains("XdmEmptySequence")) {
                test2 = true;
            }
            if (test1 && test2) {
                results.add("true");
                continue;
            }
            results.add("false");
        }
        return results;
    }

    public List<String> CheckObservationTypeCount(String href) {
        ArrayList<String> results = new ArrayList<String>();
        String context = String.format("//om:OM_Observation[om:type/@xlink:href='%s']", href);
        int count_observation = Integer.parseInt(this.CheckXPath2(String.format("count(%s)", context)));
        for (int i = 1; i <= count_observation; ++i) {
            results.add(this.CheckXPath2(String.format("(%s/om:result/text())[%s] castable as xs:integer)", context, i)));
        }
        return results;
    }

    public List<String> CheckObservationTypeTruth(String href) {
        ArrayList<String> results = new ArrayList<String>();
        String context = String.format("//om:OM_Observation[om:type/@xlink:href='%s']", href);
        int count_observation = Integer.parseInt(this.CheckXPath2(String.format("count(%s)", context)));
        for (int i = 1; i <= count_observation; ++i) {
            results.add(this.CheckXPath2(String.format("(%s/om:result/text())[%s] castable as xs:boolean", context, i)));
        }
        return results;
    }
}

