/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.om20.level1;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.apache.xerces.xs.XSModel;
import org.opengis.cite.om20.SuiteAttribute;
import org.opengis.cite.om20.util.NamespaceBindings;
import org.opengis.cite.om20.util.ValidationUtils;
import org.opengis.cite.om20.util.XMLUtils;
import org.opengis.cite.validation.XmlSchemaCompiler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DataFixture {
    protected File dataFile;
    protected Document originalSubject;
    protected Document testSubject;
    protected URI testSubjectUri;
    protected String Resource_GML_Path = "/org/opengis/cite/om20/xsd/opengis/gml/3.2.1/gml-3.2.1.xsd";
    protected String Resource_SWE_Path = "/org/opengis/cite/sweCommon/2.0/swe_2.0.1_flatten/swe_2.0.1.xsd";
    protected XSModel model;
    protected final String observation_type_measurement = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement";
    protected final String observation_type_category = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation";
    protected final String observation_type_count = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation";
    protected final String observation_type_truth = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TruthObservation";
    protected final String observation_type_complex = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ComplexObservation";
    protected final String observation_type_geometry = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_GeometryObservation";
    protected final String observation_type_temporal = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TemporalObservation";
    protected final String observation_type_swe_simple = "http://www.opengis.net/def/observationType/OGC-OM/2.0/SWEScalarObservation";
    protected final String observation_type_swe_array = "http://www.opengis.net/def/observationType/OGC-OM/2.0/SWEArrayObservation";

    @BeforeClass(alwaysRun=true)
    public void obtainTestSubject(ITestContext testContext) {
        Object uriObj;
        Assert.assertTrue((boolean)testContext.getSuite().getAttributeNames().contains(SuiteAttribute.XML.getName()), (String)"No data to validate.");
        this.dataFile = (File)testContext.getSuite().getAttribute(SuiteAttribute.XML.getName());
        this.model = (XSModel)testContext.getSuite().getAttribute(SuiteAttribute.XSMODEL.getName());
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null != obj && Document.class.isAssignableFrom(obj.getClass())) {
            this.testSubject = (Document)Document.class.cast(obj);
            this.originalSubject = (Document)Document.class.cast(obj);
        }
        if (null != (uriObj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT_URI.getName()))) {
            this.testSubjectUri = (URI)URI.class.cast(uriObj);
        }
    }

    public void setDataFile(File dataFile) {
        this.dataFile = dataFile;
    }

    public void setSchemaModel(XSModel xsModel) {
        this.model = xsModel;
    }

    public String generateXPathExpression(List<QName> elemNames, Map<String, String> namespaceBindings) {
        StringBuilder xpath = new StringBuilder();
        ListIterator<QName> itr = elemNames.listIterator();
        while (itr.hasNext()) {
            QName qName = itr.next();
            String namespace = qName.getNamespaceURI();
            String prefix = namespaceBindings.get(namespace);
            if (null == prefix) {
                prefix = namespace.equals("http://www.opengis.net/om/2.0") ? "om" : "ns" + itr.previousIndex();
                namespaceBindings.put(namespace, prefix);
            }
            xpath.append("//").append(prefix).append(":");
            xpath.append(qName.getLocalPart());
            if (!itr.hasNext()) continue;
            xpath.append(" | ");
        }
        return xpath.toString();
    }

    public File GetFileViaResourcePath(String resourcePath) {
        try {
            InputStream in = this.getClass().getResourceAsStream(resourcePath);
            if (in == null) {
                return null;
            }
            File tempFile = File.createTempFile(String.valueOf(in.hashCode()), ".tmp");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            return tempFile;
        }
        catch (IOException e) {
            URL xsdPath = this.getClass().getResource(resourcePath);
            File file = new File(xsdPath.toString().substring(5));
            return file;
        }
    }

    public Validator CreateValidator(URL xsdPath) throws XMLStreamException, SAXException, IOException {
        Set<URI> schemaRefs = ValidationUtils.extractSchemaReferences(new StreamSource(this.dataFile), this.testSubjectUri.toString());
        XmlSchemaCompiler xsdCompiler = new XmlSchemaCompiler(xsdPath);
        Schema schema = xsdCompiler.compileXmlSchema(schemaRefs.toArray(new URI[schemaRefs.size()]));
        return schema.newValidator();
    }

    public static XdmValue evaluateXPath2Modified(File xmlFile, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = builder.build(xmlFile);
        xpath.setContextItem((XdmItem)node);
        return xpath.evaluate();
    }

    public XdmValue CheckXPath2Modified(String xpath2, File xmlFile) {
        XdmValue xdmValue = null;
        try {
            xdmValue = DataFixture.evaluateXPath2Modified(xmlFile, xpath2, NamespaceBindings.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue;
    }

    public String SchemaElement(String candidateNode, String nodeName, File schemaFile) throws SaxonApiException {
        String xpath_t2_4;
        String test1_result = "true";
        if (candidateNode.equals(nodeName)) {
            String xpath_t1_1 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@abstract", nodeName.split(":")[1]);
            String bool_xpath_t1_1 = String.format("boolean(%s)", xpath_t1_1);
            if (this.CheckXPath2Modified(bool_xpath_t1_1, schemaFile).equals("true") && this.CheckXPath2Modified(xpath_t1_1, schemaFile).toString().split("=")[1].equals("\"true\"")) {
                test1_result = "false";
            }
        } else {
            String sub_name = "";
            String name = String.format("\"%s\"", candidateNode.split(":")[1]);
            while (true) {
                String xpath_t1_2;
                String result_xpath_t1_2;
                if ((result_xpath_t1_2 = this.CheckXPath2Modified(xpath_t1_2 = String.format("//xs:schema/xs:element[@name=%s]/@substitutionGroup", name), schemaFile).toString()).contains("XdmEmptySequence")) {
                    test1_result = "false";
                    break;
                }
                sub_name = result_xpath_t1_2.split("=")[1];
                if (sub_name.equals(String.format("\"%s\"", nodeName))) break;
                if (sub_name.equals("\"gml:AbstractGML\"") || sub_name.equals("\"gml:AbstractObject\"")) {
                    test1_result = "false";
                    break;
                }
                if (sub_name.equals("\"swe:AbstractSWE\"")) {
                    test1_result = "false";
                    break;
                }
                name = "\"".concat(sub_name.split(":")[1]);
            }
        }
        if (test1_result.equals("false")) {
            return "false";
        }
        String test2_result = "true";
        String xpath_t2_1 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@type", candidateNode.split(":")[1]);
        String candidateNode_type = this.CheckXPath2Modified(xpath_t2_1, schemaFile).toString();
        String xpath_t2_2 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@type", nodeName.split(":")[1]);
        String nodeName_type = this.CheckXPath2Modified(xpath_t2_2, schemaFile).toString();
        String xpath_t2_3 = String.format("boolean(//*[@name=%s])", String.format("\"%s", nodeName_type.split(":")[1]));
        if (this.CheckXPath2Modified(xpath_t2_3, schemaFile).equals("false")) {
            test2_result = "false";
        }
        if (this.CheckXPath2Modified(xpath_t2_4 = String.format("boolean(//*[@name=%s])", String.format("\"%s", candidateNode_type.split(":")[1])), schemaFile).equals("false")) {
            test2_result = "false";
        }
        if (!candidateNode_type.equals(nodeName_type)) {
            String type_element = "";
            String name_element = String.format("\"%s", candidateNode_type.split(":")[1]);
            while (true) {
                String xpath_t2_5 = String.format("//*[@name=%s]//@base", name_element);
                String result_xpath_t2_5 = "";
                if (this.CheckXPath2Modified(xpath_t2_5, schemaFile).size() > 1) {
                    result_xpath_t2_5 = this.CheckXPath2Modified(xpath_t2_5, schemaFile).itemAt(0).getStringValue();
                    type_element = String.format("\"%s\"", result_xpath_t2_5);
                } else if (this.CheckXPath2Modified(xpath_t2_5, schemaFile).size() == 1) {
                    result_xpath_t2_5 = this.CheckXPath2Modified(xpath_t2_5, schemaFile).toString();
                    type_element = result_xpath_t2_5.split("=")[1];
                } else {
                    test2_result = "false";
                    break;
                }
                if (type_element.equals(String.format("%s", nodeName_type.split("=")[1]))) break;
                if (type_element.equals("\"gml:AbstractGMLType\"")) {
                    test2_result = "false";
                    break;
                }
                name_element = "\"".concat(type_element.split(":")[1]);
            }
        }
        if (test2_result.equals("false")) {
            return "false";
        }
        String test3_result = "false";
        String xpath_t3_1 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@nillable", nodeName.split(":")[1]);
        String xpath_t3_2 = String.format("//xs:schema/xs:element[@name=\"%s\"]/@nillable", candidateNode.split(":")[1]);
        String result_xpath_t3_1 = this.CheckXPath2Modified(xpath_t3_1, schemaFile).toString();
        String result_xpath_t3_2 = this.CheckXPath2Modified(xpath_t3_2, schemaFile).toString();
        if (result_xpath_t3_1.contains("XdmEmptySequence") && result_xpath_t3_2.contains("XdmEmptySequence")) {
            test3_result = "true";
        } else if (result_xpath_t3_1.equals(result_xpath_t3_2)) {
            test3_result = "true";
        }
        if (test3_result.equals("false")) {
            return "false";
        }
        String final_result = "";
        final_result = test1_result.equals("true") && test2_result.equals("true") && test3_result.equals("true") ? "true" : "false";
        return final_result;
    }

    public Validator CreateValidatorFromXSD(URL xsdPath) throws SAXException, IOException, URISyntaxException {
        XmlSchemaCompiler compiler = new XmlSchemaCompiler(xsdPath);
        Schema schema = compiler.compileXmlSchema(new URI[]{xsdPath.toURI()});
        return schema.newValidator();
    }

    public String CheckXPath2(String xpath) {
        Object xdmValue = null;
        try {
            xdmValue = XMLUtils.evaluateXPath2(new DOMSource(this.testSubject), xpath, NamespaceBindings.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue.toString();
    }

    public List<String> CheckObservationTypeMeasurement(String href) {
        ArrayList<String> results = new ArrayList<String>();
        String context = String.format("//om:OM_Observation[om:type/@xlink:href='%s']", href);
        int count_observation = Integer.parseInt(this.CheckXPath2(String.format("count(%s)", context)));
        for (int i = 1; i <= count_observation; ++i) {
            String uom_value = String.format("(%s/om:result/@uom)[%s]", context, i);
            String result_text = String.format("(%s/om:result/text())[%s]", context, i);
            String xpath = String.format("(((%s castable as xs:string) and (string-length(%s) > 0) and (not(matches(%s, \"[: \\n\\r\\t]+\"))))  or ((%s castable as xs:anyURI) and matches(%s , \"([a-zA-Z][a-zA-Z0-9\\-\\+\\.]*:|\\.\\./|\\./|#).*\"))) and (%s castable as xs:double)", uom_value, uom_value, uom_value, uom_value, uom_value, result_text);
            results.add(this.CheckXPath2(xpath));
        }
        return results;
    }

    public List<String> CheckObservationTypeCategory(String href) {
        ArrayList<String> results = new ArrayList<String>();
        String context = String.format("//om:OM_Observation[om:type/@xlink:href='%s']", href);
        int count_observation = Integer.parseInt(this.CheckXPath2(String.format("count(%s)", context)));
        for (int i = 1; i <= count_observation; ++i) {
            boolean test1 = true;
            boolean test2 = false;
            if (this.CheckXPath2(String.format("(%s/om:result/@xlink:href)[%s]", context, i)).contains("XdmEmptySequence") || this.CheckXPath2(String.format("(%s/om:result/@xlink:title)[%s]", context, i)).contains("XdmEmptySequence")) {
                test1 = false;
            }
            if (this.CheckXPath2(String.format("(%s/om:result/*)[%s]", context, i)).contains("XdmEmptySequence") && this.CheckXPath2(String.format("(%s/om:result/text())[%s]", context, i)).contains("XdmEmptySequence")) {
                test2 = true;
            }
            if (test1 && test2) {
                results.add("true");
                continue;
            }
            results.add("false");
        }
        return results;
    }

    public List<String> CheckObservationTypeCount(String href) {
        ArrayList<String> results = new ArrayList<String>();
        String context = String.format("//om:OM_Observation[om:type/@xlink:href='%s']", href);
        int count_observation = Integer.parseInt(this.CheckXPath2(String.format("count(%s)", context)));
        for (int i = 1; i <= count_observation; ++i) {
            results.add(this.CheckXPath2(String.format("(%s/om:result/text())[%s] castable as xs:integer)", context, i)));
        }
        return results;
    }

    public List<String> CheckObservationTypeTruth(String href) {
        ArrayList<String> results = new ArrayList<String>();
        String context = String.format("//om:OM_Observation[om:type/@xlink:href='%s']", href);
        int count_observation = Integer.parseInt(this.CheckXPath2(String.format("count(%s)", context)));
        for (int i = 1; i <= count_observation; ++i) {
            results.add(this.CheckXPath2(String.format("(%s/om:result/text())[%s] castable as xs:boolean", context, i)));
        }
        return results;
    }

    public List<String> GetResultTypeHref() {
        int count_observation = Integer.parseInt(this.CheckXPath2("count(//om:OM_Observation/om:type/@xlink:href)"));
        ArrayList<String> list_href = new ArrayList<String>();
        for (int i = 1; i <= count_observation; ++i) {
            list_href.add(this.CheckXPath2(String.format("string((//om:OM_Observation/om:type/@xlink:href)[%s])", i)));
        }
        return list_href;
    }
}

