/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.report;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.Reporter;

public class ReportLog {
    public void generateLogs(ISuite suite) {
        Reporter.clear();
        Reporter.log("The result of the test is-\n\n");
        String suiteName = suite.getName();
        Map<String, ISuiteResult> suiteResults = suite.getResults();
        String input = null;
        String result = null;
        String failReport = null;
        String failReportConformance2 = ",";
        int passedTest = 0;
        int failedTest = 0;
        int skippedTest = 0;
        int finalPassedTest = 0;
        int finalSkippedTest = 0;
        int finalFailedTest = 0;
        int count = 0;
        String date = null;
        for (ISuiteResult obj : suiteResults.values()) {
            ISuiteResult sr = obj;
            ITestContext tc = sr.getTestContext();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            if (++count == 1) {
                result = tc.getAttribute("Result").toString();
                date = dateFormat.format(cal.getTime());
                input = tc.getAttribute("Input").toString();
                failReport = tc.getAttribute("FailReport").toString();
                passedTest = tc.getPassedTests().getAllResults().size();
                skippedTest = tc.getSkippedTests().getAllResults().size();
                failedTest = tc.getFailedTests().getAllResults().size();
                continue;
            }
            int no_of_failedTest = tc.getFailedTests().getAllResults().size();
            int no_of_skippedTest = tc.getSkippedTests().getAllResults().size();
            int no_of_passedTest = tc.getPassedTests().getAllResults().size();
            if (no_of_failedTest == 0 && no_of_passedTest == 0) continue;
            if (no_of_failedTest == 0 && no_of_passedTest != 0) {
                result = "Pass";
                failReportConformance2 = failReportConformance2 + ", " + input + " conform to the clause A." + count + " of ISO 19139";
            } else {
                result = "Fail";
                failReportConformance2 = failReportConformance2 + ", " + input + " does not conform to the clause A." + count + " of ISO 19139";
            }
            finalPassedTest += no_of_passedTest;
            finalSkippedTest += no_of_skippedTest;
            finalFailedTest += no_of_failedTest;
        }
        failedTest += finalFailedTest;
        skippedTest += finalSkippedTest;
        Reporter.log("**RESULT: " + result);
        Reporter.log("**INPUT: " + input);
        Reporter.log("**TEST NAME AND VERSION    :" + suiteName);
        Reporter.log("**DATE AND TIME PERFORMED  :" + date);
        Reporter.log("Passed tests for suite '" + suiteName + "' is:" + (passedTest += finalPassedTest));
        Reporter.log("Failed tests for suite '" + suiteName + "' is:" + failedTest);
        Reporter.log("Skipped tests for suite '" + suiteName + "' is:" + skippedTest);
        Reporter.log("\nREASON:\n\n");
        Reporter.log(failReport);
        Reporter.log(failReportConformance2);
    }
}

