/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.om20.level1;

import java.io.File;
import org.opengis.cite.om20.level1.DataFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class SamplingSurfaceDataValidation
extends DataFixture {
    @Test(groups={"A.16. Sampling surface data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/samplingSpatial/2.0/samplingSurface.sch")
    public void ShapeTypeConsistent() {
        if (this.CheckXPath2("boolean(//sams:SF_SpatialSamplingFeature)").equals("false")) {
            throw new SkipException("Not Spatial Sampling feature data.");
        }
        String sampling_feature_type_surface = "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface";
        String href = this.CheckXPath2("string(//sams:SF_SpatialSamplingFeature/sam:type/@xlink:href)");
        if (!href.equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface")) {
            throw new SkipException("Not Sampling surface data.");
        }
        String final_result = this.testA16("gml:AbstractSurface");
        Assert.assertTrue(final_result.equals("true"), "a member of the substitution group headed by gml:AbstractSurface or an xlink must be present as child of sams:shape");
    }

    private String testA16(String schema_element_Value) {
        String result_1 = "";
        String candidateNode = this.CheckXPath2("//sams:SF_SpatialSamplingFeature/sams:shape/*[1]/name()");
        String nodeName = schema_element_Value;
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_GML_Path);
            result_1 = this.SchemaElement(candidateNode, nodeName, schemaFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result_2 = this.CheckXPath2("boolean(//sams:SF_SpatialSamplingFeature/sams:shape/@xlink:href)");
        String final_result = "";
        final_result = result_1.equals("true") || result_2.equals("true") ? "true" : "false";
        return final_result;
    }
}

