/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationError;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ValidationErrorHandler
implements ErrorHandler,
DOMErrorHandler,
Iterable<ValidationError> {
    private StringBuffer buf = new StringBuffer();
    private String schemaLanguage;
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    public boolean errorsDetected() {
        return !this.errors.isEmpty();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    @Override
    public void warning(SAXParseException spex) {
        this.addSAXError(ErrorSeverity.WARNING, spex);
    }

    @Override
    public void error(SAXParseException spex) {
        this.addSAXError(ErrorSeverity.ERROR, spex);
    }

    @Override
    public void fatalError(SAXParseException spex) {
        this.addSAXError(ErrorSeverity.CRITICAL, spex);
    }

    private void addSAXError(ErrorSeverity severity, SAXParseException spex) {
        ValidationError error = new ValidationError(severity, spex.getMessage(), spex.getLineNumber(), spex.getColumnNumber(), null);
        this.errors.add(error);
    }

    private void addDOMError(ErrorSeverity severity, String msg, DOMLocator loc) {
        ValidationError error = new ValidationError(severity, msg, loc.getLineNumber(), loc.getColumnNumber(), "#");
        this.errors.add(error);
    }

    @Override
    public boolean handleError(DOMError error) {
        switch (error.getSeverity()) {
            case 1: {
                this.addDOMError(ErrorSeverity.WARNING, error.getMessage(), error.getLocation());
                break;
            }
            case 2: {
                this.addDOMError(ErrorSeverity.ERROR, error.getMessage(), error.getLocation());
                break;
            }
            case 3: {
                this.addDOMError(ErrorSeverity.CRITICAL, error.getMessage(), error.getLocation());
            }
        }
        return error.getSeverity() != 3;
    }

    public void addError(ErrorSeverity severity, String msg, ErrorLocator locator) {
        this.addError(severity, msg, null, locator);
    }

    public void addError(ErrorSeverity severity, String msg, String diag, ErrorLocator locator) {
        ValidationError error = new ValidationError(severity, msg, diag, locator);
        this.errors.add(error);
    }

    public String toString() {
        this.buf.setLength(0);
        for (ValidationError err : this.errors) {
            this.buf.append(err.toString());
        }
        return this.buf.toString();
    }

    public String toXml() {
        this.buf.setLength(0);
        this.buf.append("\n<errors xmlns='");
        this.buf.append("http://cite.opengeospatial.org/").append("'");
        if (null != this.schemaLanguage) {
            this.buf.append(" schemaLanguage='").append(this.schemaLanguage);
            this.buf.append("'");
        }
        this.buf.append(">");
        for (ValidationError err : this.errors) {
            this.buf.append(err.toXml());
        }
        this.buf.append("\n</errors>");
        return this.buf.toString();
    }

    @Override
    public Iterator<ValidationError> iterator() {
        return this.errors.iterator();
    }

    public void reset() {
        this.buf.setLength(0);
        this.errors.clear();
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }
}

