/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.om20.level1;

import java.io.File;
import java.net.URL;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.opengis.cite.om20.ETSAssert;
import org.opengis.cite.om20.level1.DataFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class SpatialSamplingFeatureValidation
extends DataFixture {
    @Test(groups={"A.13. Spatial Sampling feature data"}, description="Validate the XML document using the XML schema document http://schemas.opengis.net/samplingSpatial/2.0/spatialSamplingFeature.xsd")
    public void SpatialSamplingValid() {
        if (this.CheckXPath2("boolean(//sams:SF_SpatialSamplingFeature)").equals("false")) {
            throw new SkipException("Not Spatial Sampling feature data.");
        }
        URL schemaUrl = this.getClass().getResource("/org/opengis/cite/om20/xsd/opengis/om/2.0/spatialSamplingFeature.xsd");
        DOMSource source = new DOMSource(this.testSubject);
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            Validator validator = schema.newValidator();
            ETSAssert.assertSchemaValid(validator, source);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"A.13. Spatial Sampling feature data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/samplingSpatial/2.0/shapeTypeConsistent.sch")
    public void ShapeTypeConsistent() {
        if (this.CheckXPath2("boolean(//sams:SF_SpatialSamplingFeature)").equals("false")) {
            throw new SkipException("Not Spatial Sampling feature data.");
        }
        String sampling_feature_type_point = "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint";
        String sampling_feature_type_curve = "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve";
        String sampling_feature_type_surface = "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface";
        String sampling_feature_type_solid = "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSolid";
        String href = this.CheckXPath2("string(//sams:SF_SpatialSamplingFeature/sam:type/@xlink:href)");
        if (href.equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint")) {
            String final_result = this.testA13("gml:Point");
            Assert.assertTrue(final_result.equals("true"), "a member of the substitution group headed by gml:Point or an xlink must be present as child of sams:shape");
        } else if (href.equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve")) {
            String final_result = this.testA13("gml:AbstractCurve");
            Assert.assertTrue(final_result.equals("true"), "a member of the substitution group headed by gml:Curve or an xlink must be present as child of sams:shape");
        } else if (href.equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface")) {
            String final_result = this.testA13("gml:AbstractSurface");
            Assert.assertTrue(final_result.equals("true"), "a member of the substitution group headed by gml:AbstractSurface or an xlink must be present as child of sams:shape");
        } else if (href.equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSolid")) {
            String final_result = this.testA13("gml:AbstractSolid");
            Assert.assertTrue(final_result.equals("true"), "a member of the substitution group headed by gml:AbstractSolid or an xlink must be present as child of sams:shape");
        } else {
            String final_result = "false";
            Assert.assertTrue(final_result.equals("true"), "Invalid xlink:href attribute of sam:type element");
        }
    }

    private String testA13(String schema_element_Value) {
        String result_1 = "";
        String candidateNode = this.CheckXPath2("//sams:SF_SpatialSamplingFeature/sams:shape/*[1]/name()");
        String nodeName = schema_element_Value;
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_GML_Path);
            result_1 = this.SchemaElement(candidateNode, nodeName, schemaFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result_2 = this.CheckXPath2("boolean(//sams:SF_SpatialSamplingFeature/sams:shape/@xlink:href)");
        String final_result = "";
        final_result = result_1.equals("true") || result_2.equals("true") ? "true" : "false";
        return final_result;
    }
}

