/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PatternMatchExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrependIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public abstract class Pattern
implements PatternFinder,
Serializable,
Container {
    private String originalText;
    private Executable executable;
    private String systemId;
    private int lineNumber;

    public static Pattern make(String pattern, StaticContext env, Executable exec) throws XPathException {
        Pattern pat = new ExpressionParser().parsePattern(pattern, env);
        pat.setSystemId(env.getSystemId());
        pat.setLineNumber(env.getLineNumber());
        pat.setOriginalText(pattern);
        pat.setExecutable(exec);
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        visitor.setExecutable(exec);
        pat = pat.simplify(visitor);
        return pat;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public LocationProvider getLocationProvider() {
        return this.executable.getLocationMap();
    }

    public void setOriginalText(String text) {
        this.originalText = text;
    }

    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public int getDependencies() {
        return 0;
    }

    public Iterator iterateSubExpressions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public int allocateSlots(ExpressionContext env, int nextFree, SlotManager stackFrame) {
        return nextFree;
    }

    public void promote(PromotionOffer offer) throws XPathException {
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public abstract boolean matches(NodeInfo var1, XPathContext var2) throws XPathException;

    protected boolean internalMatches(NodeInfo node, XPathContext context) throws XPathException {
        return this.matches(node, context);
    }

    public SequenceIterator selectNodes(DocumentInfo doc, final XPathContext context) throws XPathException {
        int kind = this.getNodeKind();
        switch (kind) {
            case 9: {
                if (this.matches(doc, context)) {
                    return SingletonIterator.makeIterator(doc);
                }
                return EmptyIterator.getInstance();
            }
            case 2: {
                AxisIterator allElements = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
                MappingFunction atts = new MappingFunction(){

                    public SequenceIterator map(Item item) {
                        return ((NodeInfo)item).iterateAxis((byte)2);
                    }
                };
                MappingIterator allAttributes = new MappingIterator(allElements, atts);
                ItemMappingFunction test = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (Pattern.this.matches((NodeInfo)item, context)) {
                            return item;
                        }
                        return null;
                    }
                };
                return new ItemMappingIterator(allAttributes, test);
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                AxisIterator allChildren = doc.iterateAxis((byte)4, NodeKindTest.makeNodeKindTest(kind));
                ItemMappingFunction test = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (Pattern.this.matches((NodeInfo)item, context)) {
                            return item;
                        }
                        return null;
                    }
                };
                return new ItemMappingIterator(allChildren, test);
            }
            case 0: {
                AxisIterator allChildren = doc.iterateAxis((byte)4);
                MappingFunction attsOrSelf = new MappingFunction(){

                    public SequenceIterator map(Item item) {
                        return new PrependIterator((NodeInfo)item, ((NodeInfo)item).iterateAxis((byte)2));
                    }
                };
                MappingIterator attributesOrSelf = new MappingIterator(allChildren, attsOrSelf);
                ItemMappingFunction test = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (Pattern.this.matches((NodeInfo)item, context)) {
                            return item;
                        }
                        return null;
                    }
                };
                return new ItemMappingIterator(attributesOrSelf, test);
            }
            case 13: {
                throw new UnsupportedOperationException("Patterns can't match namespace nodes");
            }
        }
        throw new UnsupportedOperationException("Unknown node kind");
    }

    public Expression makeSearchExpression() {
        Expression base;
        int kind = this.getNodeKind();
        switch (kind) {
            case 9: {
                base = new ContextItemExpression();
                break;
            }
            case 2: {
                AxisExpression allElements = new AxisExpression(4, NodeKindTest.ELEMENT);
                base = new PathExpression(allElements, new AxisExpression(2, AnyNodeTest.getInstance()));
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                base = new AxisExpression(4, NodeKindTest.makeNodeKindTest(kind));
                break;
            }
            case 0: {
                AxisExpression allChildren = new AxisExpression(4, NodeKindTest.ELEMENT);
                Block block = new Block();
                Expression[] union = new Expression[]{new ContextItemExpression(), new AxisExpression(2, AnyNodeTest.getInstance())};
                block.setChildren(union);
                base = new PathExpression(allChildren, block);
                break;
            }
            case 13: {
                throw new UnsupportedOperationException("Patterns can't match namespace nodes");
            }
            default: {
                throw new UnsupportedOperationException("Unknown node kind");
            }
        }
        return new FilterExpression(base, new PatternMatchExpression(this));
    }

    public int getNodeKind() {
        return 0;
    }

    public int getFingerprint() {
        return -1;
    }

    public abstract NodeTest getNodeTest();

    public double getDefaultPriority() {
        return 0.5;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String toString() {
        if (this.originalText != null) {
            return this.originalText;
        }
        return "pattern matching " + this.getNodeTest().toString();
    }

    public int getHostLanguage() {
        return 50;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        throw new IllegalArgumentException("Invalid replacement");
    }
}

