/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.om20.level1;

import java.io.File;
import java.util.List;
import org.opengis.cite.om20.level1.DataFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class ArrayObservationValidation
extends DataFixture {
    @Test(groups={"A.10. SWE array observation data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/om/2.0/SWEArrayObservation.sch")
    public void ResultSWEBlock() {
        List<String> href = this.GetResultTypeHref();
        this.getClass();
        if (!href.contains("http://www.opengis.net/def/observationType/OGC-OM/2.0/SWEArrayObservation")) {
            throw new SkipException("Not SWE array observation.");
        }
        String candidateNode = this.CheckXPath2("//om:result/*[1]/name()");
        String nodeName_1 = "swe:DataArray";
        String nodeName_2 = "swe:Matrix";
        String nodeName_3 = "swe:DataStream";
        String inline_value = this.CheckXPath2("boolean(//om:result/*[1]/swe:values)");
        String final_result = "";
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_SWE_Path);
            String result_1 = this.SchemaElement(candidateNode, nodeName_1, schemaFile);
            String result_2 = this.SchemaElement(candidateNode, nodeName_2, schemaFile);
            String result_3 = this.SchemaElement(candidateNode, nodeName_3, schemaFile);
            final_result = (result_1.equals("true") || result_2.equals("true") || result_3.equals("true")) && inline_value.equals("true") ? "true" : "false";
            Assert.assertTrue(final_result.equals("true"), "result must contain an element in the substitution group headed by swe:DataArray, swe:Matrix or swe:DataStream and with inline values.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

