/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.om20.level1;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.om20.Namespaces;
import org.opengis.cite.om20.SuiteAttribute;
import org.opengis.cite.om20.TestRunArg;
import org.opengis.cite.om20.level1.DataFixture;
import org.opengis.cite.om20.util.NamespaceResolver;
import org.opengis.cite.om20.util.TestSuiteLogger;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.log4testng.Logger;
import org.w3c.dom.NodeList;

public class SchematronTests
extends DataFixture {
    private SchematronValidator dataValidator;

    @BeforeClass
    public void createSchematronValidator(ITestContext testContext) {
        Map<String, String> piData = this.getXmlModelPIData(this.dataFile);
        String phase = "#ALL";
        StreamSource schema = null;
        if (this.isSchematronReference(piData)) {
            URI schematronURI = URI.create(piData.get("href"));
            if (!schematronURI.isAbsolute()) {
                String dataURI = testContext.getSuite().getParameter(TestRunArg.GML.toString());
                URI baseURI = URI.create(dataURI);
                schematronURI = baseURI.resolve(schematronURI);
            }
            schema = new StreamSource(schematronURI.toString());
            if (piData.containsKey("phase")) {
                phase = piData.get("phase");
            }
        } else {
            Set<String> suiteAttrs = testContext.getSuite().getAttributeNames();
            if (suiteAttrs.contains(SuiteAttribute.SCHEMATRON.getName())) {
                URI schematronURI = (URI)testContext.getSuite().getAttribute(SuiteAttribute.SCHEMATRON.getName());
                schema = new StreamSource(schematronURI.toString());
            }
        }
        if (null != schema) {
            try {
                this.dataValidator = new SchematronValidator(schema, phase);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).warn("Failed to create SchematronValidator.\n", e);
            }
        }
    }

    public boolean xpathHasNodes(String strXPath) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        xpath.setNamespaceContext(new NamespaceResolver(this.testSubject));
        XPathExpression xPathExpr = xpath.compile(strXPath);
        try {
            Object rs = xPathExpr.evaluate(this.testSubject, XPathConstants.NODESET);
            if (rs != null) {
                NodeList nodes = (NodeList)rs;
                return nodes.getLength() > 0;
            }
            return false;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    boolean isSchematronReference(Map<String, String> piData) {
        if (null != piData && null != piData.get("schematypens")) {
            return piData.get("schematypens").equals(Namespaces.SCH);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getXmlModelPIData(File dataFile) {
        HashMap<String, String> piData = null;
        XMLStreamReader reader = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(dataFile);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            reader = factory.createXMLStreamReader(input);
            int event = reader.getEventType();
            while (event != 1) {
                event = reader.next();
                if (event != 3 || !reader.getPITarget().equals("xml-model")) continue;
                String[] pseudoAttrs = reader.getPIData().split("\\s+");
                piData = new HashMap<String, String>();
                for (String pseudoAttr : pseudoAttrs) {
                    String[] nv = pseudoAttr.split("=");
                    piData.put(nv[0].trim(), nv[1].replace('\"', ' ').trim());
                }
                break;
            }
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to parse document at " + dataFile.getAbsolutePath(), e);
            Map<String, String> map = null;
            return map;
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception x) {
                TestSuiteLogger.log(Level.INFO, x.getMessage());
            }
        }
        return piData;
    }
}

