/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.om20.level1;

import java.io.File;
import java.util.List;
import java.util.Objects;
import org.opengis.cite.om20.level1.DataFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class ScalarObservationValidation
extends DataFixture {
    @Test(groups={"A.9. SWE scalar observation data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/om/2.0/SWEScalarObservation.sch")
    public void ResultSWEscalar() {
        List<String> href = this.GetResultTypeHref();
        Objects.requireNonNull(this);
        if (!href.contains("http://www.opengis.net/def/observationType/OGC-OM/2.0/SWEScalarObservation")) {
            throw new SkipException("Not SWE scalar observation.");
        }
        String candidateNode = this.CheckXPath2("//om:result/*[1]/name()");
        String inline_value = this.CheckXPath2("boolean(//om:result/*[1]/swe:value)");
        String nodeName = "swe:AbstractSimpleComponent";
        String final_result = "";
        try {
            File schemaFile = this.GetFileViaResourcePath(this.Resource_SWE_Path);
            String result = this.SchemaElement(candidateNode, nodeName, schemaFile);
            final_result = result.equals("true") && inline_value.equals("true") ? "true" : "false";
            Assert.assertTrue((boolean)final_result.equals("true"), (String)"XML element om:result must contain an element in the substitution group headed by swe:AbstractSimpleComponent with an inline value.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

