/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.om20.level1;

import java.io.File;
import net.sf.saxon.s9api.SaxonApiException;
import org.opengis.cite.om20.level1.DataFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class SpatialObservationValidation
extends DataFixture {
    @Test(groups={"A.11. Spatial observation data"}, description="Validate the XML document using the Schematron document http://schemas.opengis.net/om/2.0/spatialObservation.sch")
    public void SpatialParameter() {
        if (this.CheckXPath2("boolean(//*[om:resultTime]/om:parameter)").equals("false")) {
            throw new SkipException("Not Spatial observation data.");
        }
        if (this.CheckXPath2("boolean(//om:parameter/om:NamedValue/om:name[@xlink:href = 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry'] | /om:parameter/om:NamedValue[om:name/@xlink:href= 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry'])").equals("false")) {
            throw new SkipException("Not Spatial observation data.");
        }
        String result_1 = "true";
        String xpath_rule1 = "count(//om:parameter/om:NamedValue/om:name[@xlink:href = 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry']) = 1";
        if (this.CheckXPath2(xpath_rule1).equals("false")) {
            result_1 = "false";
        }
        String result_2 = "true";
        String xpath_rule2 = "//*[om:resultTime]/om:parameter/om:NamedValue[om:name/@xlink:href= 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry']/om:value/*[1]/name()";
        String candidateNode = this.CheckXPath2(xpath_rule2);
        String nodeName = "gml:AbstractGeometry";
        if (candidateNode.contains("XdmEmptySequence")) {
            result_2 = "false";
        } else {
            try {
                File schemaFile = this.GetFileViaResourcePath(this.Resource_GML_Path);
                result_2 = this.SchemaElement(candidateNode, nodeName, schemaFile);
            }
            catch (SaxonApiException e) {
                e.printStackTrace();
            }
        }
        String final_result = "";
        final_result = result_1.equals("true") && result_2.equals("true") ? "true" : "false";
        Assert.assertTrue((boolean)final_result.equals("true"), (String)"A spatial observation MUST have exactly one sampling geometry encoded as XML element om:parameter in an observation.\tThe xlink:href attribute in the XML element om:name of the om:parameter/om:NamedValue element that \tcarries the sampling geometry MUST have the value 'http://www.opengis.net/req/omxml/2.0/data/samplingGeometry'. \tAnd, the XML element om:value in the om:parameter/om:NamedValue element which carries the sampling \tgeometry MUST have a value of type gml:AbstractGeometry");
    }
}

