/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.om20.level1;

import java.net.URL;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.opengis.cite.om20.ETSAssert;
import org.opengis.cite.om20.level1.DataFixture;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class SpecimenObservationValidation
extends DataFixture {
    @Test(groups={"A.18. Specimen data"}, description="Validate the XML document using the XML Schema document http://schemas.opengis.net/samplingSpecimen/2.0/specimen.xsd")
    public void SpecimenValid() {
        if (this.CheckXPath2("boolean(//spec:SF_Specimen)").equals("false")) {
            throw new SkipException("Not Specimen data.");
        }
        URL schemaUrl = this.getClass().getResource("/org/opengis/cite/om20/xsd/opengis/om/2.0/specimen.xsd");
        DOMSource source = new DOMSource(this.testSubject);
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            Validator validator = schema.newValidator();
            ETSAssert.assertSchemaValid(validator, source);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

