/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs;

import com.occamlab.te.spi.jaxrs.TestSuiteController;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestSuiteRegistry {
    private static final Logger logger = Logger.getLogger(TestSuiteRegistry.class.getPackage().getName());
    private static volatile TestSuiteRegistry registry;
    private Set<TestSuiteController> controllers = new HashSet<TestSuiteController>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TestSuiteRegistry getInstance() {
        if (null != registry) return registry;
        Class<TestSuiteRegistry> clazz = TestSuiteRegistry.class;
        synchronized (TestSuiteRegistry.class) {
            if (registry != null) return registry;
            registry = new TestSuiteRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public Set<TestSuiteController> getControllers() {
        return this.controllers;
    }

    public TestSuiteController getController(String etsCode, String etsVersion) {
        if (etsCode.length() == 0 || etsCode == null) {
            throw new IllegalArgumentException("ETS code not specified.");
        }
        if (etsVersion.length() == 0 || etsVersion == null) {
            throw new IllegalArgumentException("ETS version not specified.");
        }
        TestSuiteController controller = null;
        if (!this.controllers.isEmpty()) {
            for (TestSuiteController ets : this.controllers) {
                if (!ets.getCode().equalsIgnoreCase(etsCode) || !ets.getVersion().equalsIgnoreCase(etsVersion)) continue;
                controller = ets;
                break;
            }
        }
        return controller;
    }

    private TestSuiteRegistry() {
        this.loadControllers();
    }

    private void loadControllers() {
        ClassLoader loader = this.getClass().getClassLoader();
        ServiceLoader<TestSuiteController> srvLoader = ServiceLoader.load(TestSuiteController.class, loader);
        for (TestSuiteController controller : srvLoader) {
            this.controllers.add(controller);
        }
        logger.log(Level.CONFIG, "Loaded {0} TestSuiteController implementations.", this.controllers.size());
    }
}

