/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.owc10.atom;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.owc10.CommonFixture;
import org.opengis.cite.owc10.ETSAssert;
import org.opengis.cite.owc10.ErrorMessage;
import org.opengis.cite.owc10.OWC10;
import org.opengis.cite.owc10.SuiteAttribute;
import org.opengis.cite.owc10.util.TestSuiteLogger;
import org.opengis.cite.owc10.util.URIUtils;
import org.opengis.cite.owc10.util.ValidationUtils;
import org.opengis.cite.owc10.util.XMLUtils;
import org.opengis.cite.validation.RelaxNGValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class AtomCoreTests
extends CommonFixture {
    private Document contextDoc;
    private LSResourceResolver resolver;

    @BeforeClass
    public void initFixture(ITestContext testContext) {
        Object iutRef = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJ_URI.getName());
        if (null == iutRef) {
            iutRef = this.contextFile.toURI();
        }
        try {
            this.contextDoc = URIUtils.parseURI(this.contextFile.toURI());
            this.contextDoc.setDocumentURI(iutRef.toString());
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to parse resource retrieved from " + iutRef, x);
        }
        this.resolver = ValidationUtils.createSchemaResolver(URI.create("http://relaxng.org/ns/structure/1.0"));
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append(iutRef).append("\n");
            logMsg.append(XMLUtils.writeNodeToString(this.contextDoc));
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }

    @Test(description="Req: http://www.opengis.net/spec/owc-atom/1.0/req/core")
    public void isAtomFeed() {
        Element docElem = this.contextDoc.getDocumentElement();
        ETSAssert.assertQualifiedName(docElem, OWC10.ATOM_FEED);
    }

    @Test(description="Req: http://www.opengis.net/spec/owc-atom/1.0/req/atomRules")
    public void assessSchemaValidity() throws SAXException, IOException {
        URL schemaRef = this.getClass().getResource("/org/opengis/cite/owc10/rnc/owc.rnc");
        RelaxNGValidator rngValidator = new RelaxNGValidator(schemaRef, this.resolver);
        DOMSource xmlSource = null != this.contextDoc ? new DOMSource(this.contextDoc) : null;
        rngValidator.validate(xmlSource);
        ValidationErrorHandler err = rngValidator.getErrorHandler();
        Assert.assertFalse(err.errorsDetected(), ErrorMessage.format("NotSchemaValid", err.getErrorCount(), err.toString()));
    }

    @Test(description="Req: http://www.opengis.net/spec/owc-atom/1.0/req/owcEncoding")
    public void checkSchematronRules() {
        if (null == this.contextDoc) {
            Assert.fail("No context document.");
        }
        DOMSource source = new DOMSource(this.contextDoc);
        URL schemaUrl = this.getClass().getResource("/org/opengis/cite/owc10/sch/owc-atom.sch");
        ETSAssert.assertSchematronValid(schemaUrl, source, null);
    }
}

