/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.owc10.atom;

import java.net.URL;
import java.util.Collections;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.owc10.CommonFixture;
import org.opengis.cite.owc10.ETSAssert;
import org.opengis.cite.owc10.util.XMLUtils;
import org.testng.SkipException;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class AtomWmsTests
extends CommonFixture {
    private static final String WMS_PHASE = "AtomWmsPhase";

    @BeforeTest
    public void hasWmsOfferings() {
        XdmValue result;
        String xpath = String.format("//owc:offering[@code='%s']", "http://www.opengis.net/spec/owc-atom/1.0/req/wms");
        StreamSource source = new StreamSource(this.contextFile);
        try {
            result = XMLUtils.evaluateXPath2(source, xpath, Collections.singletonMap("http://www.opengis.net/owc/1.0", "owc"));
        }
        catch (SaxonApiException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        if (result.size() == 0) {
            throw new SkipException("No WMS offerings found.");
        }
    }

    @Test(description="Req: http://www.opengis.net/spec/owc-atom/1.0/req/wms/content")
    public void checkSchematronRulesForWmsOfferings() {
        StreamSource source = new StreamSource(this.contextFile);
        URL schemaUrl = this.getClass().getResource("/org/opengis/cite/owc10/sch/owc-atom-ext.sch");
        ETSAssert.assertSchematronValid(schemaUrl, source, WMS_PHASE);
    }
}

