/*
 * Decompiled with CFR 0.152.
 */
package com.galdosinc.glib.xml.jaxp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.impl.dtd.XMLSimpleType;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidatingDocumentBuilder
extends DocumentBuilder {
    private DocumentBuilder documentBuilder;
    private Map dtds;

    public ValidatingDocumentBuilder(DocumentBuilder documentBuilder, ErrorHandler errorHandler, Map dtds) {
        this.documentBuilder = documentBuilder;
        documentBuilder.setErrorHandler(errorHandler);
        this.dtds = dtds;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.documentBuilder.getDOMImplementation();
    }

    @Override
    public boolean isNamespaceAware() {
        return this.documentBuilder.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.documentBuilder.isValidating();
    }

    @Override
    public Document newDocument() {
        return this.documentBuilder.newDocument();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.documentBuilder.setErrorHandler(errorHandler);
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.documentBuilder.setEntityResolver(entityResolver);
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        return this.documentBuilder.parse(is);
    }

    @Override
    public Document parse(File file) throws SAXException, IOException {
        Document document = this.documentBuilder.parse(file);
        return document;
    }

    @Override
    public Document parse(InputStream inputStream, String systemId) throws SAXException, IOException {
        Document document = this.documentBuilder.parse(inputStream, systemId);
        this.validateDocument(document);
        return document;
    }

    @Override
    public Document parse(InputStream inputStream) throws SAXException, IOException {
        Document document = this.documentBuilder.parse(inputStream);
        this.validateDocument(document);
        return document;
    }

    @Override
    public Document parse(String uri) throws SAXException, IOException {
        Document document = this.documentBuilder.parse(uri);
        this.validateDocument(document);
        return document;
    }

    private void validateDocument(Document document) throws SAXException, IOException {
        DocumentType docType = document.getDoctype();
        if (docType != null) {
            String documentDtd = docType.getSystemId();
            String rootElement = docType.getName();
            String expectedDtd = (String)this.dtds.get(rootElement);
            if (!this.compareDtd(expectedDtd, documentDtd)) {
                throw new SAXException("The dtd " + documentDtd + " does not match the dtd expected from the specification");
            }
        }
    }

    public boolean compareDtd(String cachedDtdUrl, String dtdUrl) {
        try {
            XMLGrammarPreparser grammerParser = this.getGrammarParser();
            DTDGrammar cachedDtd = (DTDGrammar)this.getGrammar(cachedDtdUrl);
            DTDGrammar dtd = (DTDGrammar)this.getGrammar(dtdUrl);
            XMLElementDecl cachedElement = new XMLElementDecl();
            XMLElementDecl element = new XMLElementDecl();
            XMLAttributeDecl cachedAttribute = new XMLAttributeDecl();
            XMLAttributeDecl attribute = new XMLAttributeDecl();
            int i = cachedDtd.getFirstElementDeclIndex();
            while (i != -1) {
                if (cachedDtd.getElementDecl(i, cachedElement) && dtd.getElementDecl(i, element)) {
                    String spec;
                    if (!cachedElement.name.equals((Object)element.name)) {
                        return false;
                    }
                    String cachedSpec = cachedDtd.getContentSpecAsString(i);
                    if (cachedSpec != (spec = dtd.getContentSpecAsString(i)) && !cachedSpec.equals(spec)) {
                        return false;
                    }
                    boolean moreAttributes = true;
                    int j = cachedDtd.getFirstAttributeDeclIndex(i);
                    while (j != -1) {
                        if (cachedDtd.getAttributeDecl(j, cachedAttribute) && dtd.getAttributeDecl(j, attribute)) {
                            XMLSimpleType cachedType = cachedAttribute.simpleType;
                            XMLSimpleType type = attribute.simpleType;
                            if (!cachedAttribute.name.equals((Object)attribute.name)) {
                                return false;
                            }
                            if (cachedType.defaultType != type.defaultType) {
                                return false;
                            }
                            if (cachedType.defaultValue != type.defaultValue && !cachedType.defaultValue.equals(type.defaultValue)) {
                                return false;
                            }
                            if (!Arrays.equals(cachedType.enumeration, type.enumeration)) {
                                return false;
                            }
                            if (cachedType.list != type.list) {
                                return false;
                            }
                            if (!cachedType.name.equals(type.name)) {
                                return false;
                            }
                            if (cachedType.nonNormalizedDefaultValue != type.nonNormalizedDefaultValue && !cachedType.nonNormalizedDefaultValue.equals(type.nonNormalizedDefaultValue)) {
                                return false;
                            }
                            if (cachedType.type != type.type) {
                                return false;
                            }
                        }
                        j = cachedDtd.getNextAttributeDeclIndex(j);
                    }
                }
                i = cachedDtd.getNextElementDeclIndex(i);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Grammar getGrammar(String urlString) throws Exception {
        URL url = new URL(urlString);
        InputStream in = url.openStream();
        return this.getGrammarParser().preparseGrammar("http://www.w3.org/TR/REC-xml", new XMLInputSource(urlString, urlString, urlString, in, null));
    }

    private XMLGrammarPreparser getGrammarParser() {
        XMLGrammarPreparser grammerParser = new XMLGrammarPreparser();
        grammerParser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        grammerParser.registerPreparser("http://www.w3.org/TR/REC-xml", null);
        return grammerParser;
    }
}

