/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.general;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.validation.Schema;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.general.AppSchemaInfo;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.validation.XSModelBuilder;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GeneralSchemaTests {
    private Schema appSchema;
    private XSModel model;
    private URI targetNamespace;
    private AppSchemaInfo schemaInfo;

    @BeforeClass
    public void createSchemaModel(ITestContext testContext) {
        Object schema = testContext.getSuite().getAttribute(SuiteAttribute.SCHEMA.getName());
        if (null == schema || !Schema.class.isAssignableFrom(schema.getClass())) {
            throw new MissingResourceException("Unable to obtain Schema object from ITestContext", SuiteAttribute.SCHEMA.getType().getName(), SuiteAttribute.SCHEMA.getName());
        }
        this.appSchema = (Schema)Schema.class.cast(schema);
        Set schemaURIs = (Set)testContext.getSuite().getAttribute(SuiteAttribute.SCHEMA_LOC_SET.getName());
        this.targetNamespace = this.getApplicationNamespaceName(schemaURIs);
        this.model = XSModelBuilder.buildXMLSchemaModel((Schema)this.appSchema, (String)this.targetNamespace.toString());
        if (null != this.model) {
            testContext.getSuite().setAttribute(SuiteAttribute.XSMODEL.getName(), (Object)this.model);
        }
        this.schemaInfo = new AppSchemaInfo();
        testContext.getSuite().setAttribute(SuiteAttribute.SCHEMA_INFO.getName(), (Object)this.schemaInfo);
    }

    @Test(description="See ISO 19136: 21.2.2, A.1.1.1")
    public void declareTargetNamespace() {
        Assert.assertTrue((boolean)this.targetNamespace.isAbsolute(), (String)ErrorMessage.format("RelativeNamespace", this.targetNamespace.toString()));
        Assert.assertNotEquals((Object)this.targetNamespace, (Object)URI.create("http://www.opengis.net/gml/3.2"), (String)ErrorMessage.get("UnexpectedNamespace"));
    }

    @Test(description="See ISO 19136: 21.2.3, A.1.1.3")
    public void importFullGMLSchema() {
        XSNamedMap gmlElemDecls = this.model.getComponentsByNamespace((short)2, "http://www.opengis.net/gml/3.2");
        Assert.assertEquals((int)gmlElemDecls.getLength(), (int)474, (String)ErrorMessage.get("ImportFullGML"));
    }

    @Test(description="See ISO 19136: 21.2.1, A.1.1.2")
    public void declaresGMLObjects() {
        this.schemaInfo.setFeatureTypes(XMLSchemaModelUtils.getFeatureDeclarations(this.model));
        this.schemaInfo.setGeometryTypes(XMLSchemaModelUtils.getGeometryDeclarations(this.model));
        this.schemaInfo.setTopoTypes(XMLSchemaModelUtils.getTopologyDeclarations(this.model));
        this.schemaInfo.setTimeTypes(XMLSchemaModelUtils.getTimeObjectDeclarations(this.model));
        this.schemaInfo.setCrsTypes(XMLSchemaModelUtils.getCRSDeclarations(this.model));
        this.schemaInfo.setCoverageTypes(XMLSchemaModelUtils.getCoverageDeclarations(this.model));
        this.schemaInfo.setObservationTypes(XMLSchemaModelUtils.getObservationDeclarations(this.model));
        this.schemaInfo.setDefinitionTypes(XMLSchemaModelUtils.getDefinitionDeclarations(this.model));
        TestSuiteLogger.log(Level.FINE, "GML objects declared in app schema\n {0}", new Object[]{this.schemaInfo.toString()});
        Assert.assertTrue((boolean)this.schemaInfo.conforms(), (String)ErrorMessage.get("GMLDefsNotFound"));
    }

    AppSchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URI getApplicationNamespaceName(Set<URI> schemaLocations) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        String tns = null;
        for (URI uri : schemaLocations) {
            InputStream inStream = null;
            try {
                inStream = uri.toURL().openStream();
                XMLEventReader reader = factory.createXMLEventReader(inStream, "UTF-8");
                StartElement docElem = reader.nextTag().asStartElement();
                Attribute targetNS = docElem.getAttributeByName(new QName("targetNamespace"));
                if (null == targetNS || targetNS.getValue().contains("opengis.net")) continue;
                tns = targetNS.getValue();
                break;
            }
            catch (Exception e) {
                TestSuiteLogger.log(Level.WARNING, "Failed to read schema from " + uri, e);
            }
            finally {
                if (null == inStream) continue;
                try {
                    inStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        return URI.create(tns);
    }
}

