/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.io.File;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.ImmutableEnvelope;
import org.geotoolkit.referencing.CRS;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class FeatureTypeInfo {
    private QName typeName;
    private ImmutableEnvelope geoExtent;
    private boolean instantiated;
    private String defaultCRSRef;
    private CoordinateReferenceSystem defaultCRS;
    private File sampleData;

    public QName getTypeName() {
        return this.typeName;
    }

    public void setTypeName(QName typeName) {
        this.typeName = typeName;
    }

    public boolean isInstantiated() {
        return this.instantiated;
    }

    public void setInstantiated(boolean available) {
        this.instantiated = available;
    }

    public String getDefaultCRS() {
        return this.defaultCRSRef;
    }

    public void setDefaultCRS(String crsRef) throws FactoryException {
        this.defaultCRS = CRS.decode((String)crsRef);
        this.defaultCRSRef = crsRef;
    }

    public ImmutableEnvelope getGeoExtent() {
        if (null == this.geoExtent) {
            this.geoExtent = this.defaultEnvelope(this.defaultCRSRef);
        }
        return this.geoExtent;
    }

    public void setGeoExtent(ImmutableEnvelope geoExtent) {
        if (!geoExtent.getCoordinateReferenceSystem().equals(this.defaultCRS)) {
            Envelope bbox = null;
            try {
                bbox = Envelopes.transform((Envelope)geoExtent, (CoordinateReferenceSystem)this.defaultCRS);
            }
            catch (TransformException e) {
                throw new IllegalArgumentException("Failed to transform envelope coordinates to CRS " + this.defaultCRSRef, e);
            }
            this.geoExtent = new ImmutableEnvelope(bbox);
        } else {
            this.geoExtent = geoExtent;
        }
    }

    public File getSampleData() {
        return this.sampleData;
    }

    public void setSampleData(File sampleData) {
        this.sampleData = sampleData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FeatureTypeInfo {");
        sb.append("\n typeName: '").append(this.typeName);
        sb.append("',\n defaultCRS: '").append(this.defaultCRSRef);
        sb.append("',\n instantiated: ").append(this.instantiated);
        sb.append(",\n envelope: '").append(Envelopes.toWKT((Envelope)this.getGeoExtent()));
        if (this.sampleData != null && this.sampleData.exists()) {
            sb.append("',\n data: '").append(this.sampleData.toString());
        }
        sb.append("'\n}");
        return sb.toString();
    }

    ImmutableEnvelope defaultEnvelope(String crsRef) {
        ImmutableEnvelope envelope = null;
        try {
            envelope = GeodesyUtils.getDomainOfValidity((String)crsRef);
        }
        catch (FactoryException e) {
            TestSuiteLogger.log(Level.WARNING, "Cannot determine domain of validity for CRS " + this.defaultCRSRef, (Exception)((Object)e));
        }
        return envelope;
    }
}

