/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.TestRunArg;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.URIUtils;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.Reporter;
import org.w3c.dom.Document;

public class SuiteFixtureListener
implements ISuiteListener {
    public void onStart(ISuite suite) {
        Schema wfsSchema = ValidationUtils.createWFSSchema();
        if (null != wfsSchema) {
            suite.setAttribute(SuiteAttribute.WFS_SCHEMA.getName(), (Object)wfsSchema);
        }
        this.processWfsParameter(suite);
        this.setAppSchemaParameter(suite);
        Reporter.clear();
        StringBuilder str = new StringBuilder("Initial test run parameters:\n");
        str.append(suite.getXmlSuite().getAllParameters().toString());
        Reporter.log((String)str.toString());
        TestSuiteLogger.log(Level.CONFIG, str.toString());
    }

    public void onFinish(ISuite suite) {
        Reporter.log((String)("Success? " + !suite.getSuiteState().isFailed()));
        String reportDir = suite.getOutputDirectory();
        String msg = String.format("Test run directory: %s", reportDir.substring(0, reportDir.lastIndexOf(File.separatorChar)));
        Reporter.log((String)msg);
    }

    void processWfsParameter(ISuite suite) {
        String wfsRef;
        Map params = suite.getXmlSuite().getParameters();
        String iutRef = (String)params.get(TestRunArg.IUT.toString());
        String string = wfsRef = null != iutRef ? iutRef : (String)params.get(TestRunArg.WFS.toString());
        if (null == wfsRef || wfsRef.isEmpty()) {
            throw new IllegalArgumentException("Required parameter not found");
        }
        URI wfsURI = URI.create(wfsRef);
        Document doc = null;
        try {
            doc = URIUtils.resolveURIAsDocument(wfsURI);
            if (!doc.getDocumentElement().getLocalName().equals("WFS_Capabilities")) {
                throw new RuntimeException("Did not receive WFS capabilities document: " + doc.getDocumentElement().getNodeName());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse resource located at " + wfsURI, ex);
        }
        if (null != doc) {
            suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), (Object)doc);
            Map<QName, FeatureTypeInfo> featureInfo = ServiceMetadataUtils.extractFeatureInfo(doc);
            suite.setAttribute(SuiteAttribute.FEATURE_INFO.getName(), featureInfo);
            if (TestSuiteLogger.isLoggable(Level.FINER)) {
                StringBuilder logMsg = new StringBuilder("Parsed resource from ");
                logMsg.append(wfsURI).append("\n");
                logMsg.append(XMLUtils.writeNodeToString(doc));
                TestSuiteLogger.log(Level.FINER, logMsg.toString());
            }
        }
    }

    void setAppSchemaParameter(ISuite suite) {
        if (null == suite.getAttribute(SuiteAttribute.TEST_SUBJECT.getName())) {
            return;
        }
        Document wfsMetadata = (Document)suite.getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(wfsMetadata, "DescribeFeatureType", ProtocolBinding.GET);
        if (endpoint.isAbsolute()) {
            StringBuilder reqURI = new StringBuilder(endpoint.toString());
            reqURI.append("?service=WFS&version=2.0.0&request=DescribeFeatureType");
            Map params = suite.getXmlSuite().getParameters();
            params.put(org.opengis.cite.iso19136.TestRunArg.XSD.toString(), reqURI.toString());
        }
    }
}

