/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.awt.RenderingHints;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jcip.annotations.Immutable;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.naming.DefaultNameFactory;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.WeakValueHashMap;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@Immutable
public class NamedIdentifier
extends DefaultReferenceIdentifier
implements GenericName {
    private static final long serialVersionUID = 8474731565582774497L;
    private static final Map<CharSequence, NameSpace> SCOPES = new WeakValueHashMap();
    private static DefaultNameFactory nameFactory;
    private GenericName name;

    public NamedIdentifier(ReferenceIdentifier referenceIdentifier) {
        super(referenceIdentifier);
        if (referenceIdentifier instanceof GenericName) {
            this.name = (GenericName)((Object)referenceIdentifier);
        }
    }

    public NamedIdentifier(Map<String, ?> map) throws IllegalArgumentException {
        super(map);
    }

    public NamedIdentifier(Citation citation, InternationalString internationalString) {
        this(citation, internationalString.toString(null));
        this.name = this.createName(citation, internationalString);
    }

    public NamedIdentifier(Citation citation, String string) {
        this(citation, string, null);
    }

    public NamedIdentifier(Citation citation, String string, String string2) {
        super(citation, NamedIdentifier.getCodeSpace((Citation)citation), string, string2, null);
    }

    NamedIdentifier(Map<String, ?> map, boolean bl) throws IllegalArgumentException {
        super(map, bl);
    }

    private synchronized GenericName getName() {
        if (this.name == null) {
            this.name = this.createName(this.authority, this.code);
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericName createName(Citation citation, CharSequence charSequence) {
        NameSpace nameSpace;
        DefaultNameFactory defaultNameFactory = NamedIdentifier.getNameFactory();
        if (citation == null) {
            return defaultNameFactory.createLocalName(null, charSequence);
        }
        CharSequence charSequence2 = this.codeSpace != null ? this.codeSpace : NamedIdentifier.getShortestTitle((Citation)citation);
        Map<CharSequence, NameSpace> map = SCOPES;
        synchronized (map) {
            nameSpace = SCOPES.get(charSequence2);
            if (nameSpace == null) {
                nameSpace = defaultNameFactory.createNameSpace(defaultNameFactory.createLocalName(null, charSequence2), null);
                SCOPES.put(charSequence2, nameSpace);
            }
        }
        return defaultNameFactory.createLocalName(nameSpace, charSequence).toFullyQualifiedName();
    }

    static DefaultNameFactory getNameFactory() {
        DefaultNameFactory defaultNameFactory = nameFactory;
        if (defaultNameFactory == null) {
            nameFactory = defaultNameFactory = (DefaultNameFactory)FactoryFinder.getNameFactory((Hints)new Hints((RenderingHints.Key)Hints.NAME_FACTORY, DefaultNameFactory.class));
        }
        return defaultNameFactory;
    }

    @Override
    public LocalName tip() {
        return this.getName().tip();
    }

    @Override
    public LocalName head() {
        return this.getName().head();
    }

    @Override
    public NameSpace scope() {
        return this.getName().scope();
    }

    @Override
    public int depth() {
        return this.getName().depth();
    }

    @Override
    public List<? extends LocalName> getParsedNames() {
        return this.getName().getParsedNames();
    }

    @Override
    public ScopedName push(GenericName genericName) {
        return this.getName().push(genericName);
    }

    @Override
    public GenericName toFullyQualifiedName() {
        return this.getName().toFullyQualifiedName();
    }

    @Override
    public InternationalString toInternationalString() {
        return this.getName().toInternationalString();
    }

    @Override
    public String toString() {
        return ((Object)this.getName()).toString();
    }

    @Override
    public int compareTo(GenericName genericName) {
        return this.getName().compareTo(genericName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            NamedIdentifier namedIdentifier = (NamedIdentifier)object;
            return Utilities.equals((Object)this.getName(), (Object)namedIdentifier.getName());
        }
        return false;
    }

    static {
        Factories.addChangeListener((ChangeListener)new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                nameFactory = null;
            }
        });
    }
}

