/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.opengis.referencing.operation.Matrix;

public class AffineMatrix3
extends AffineTransform
implements Matrix,
Cloneable {
    private static final long serialVersionUID = -9104194268576601386L;
    public static final int SIZE = 3;

    public AffineMatrix3() {
    }

    public AffineMatrix3(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d2, d3, d4, d5, d6);
    }

    public AffineMatrix3(AffineTransform affineTransform) {
        super(affineTransform);
    }

    public AffineMatrix3(Matrix matrix) throws IllegalArgumentException {
        super(AffineMatrix3.getElements(matrix));
    }

    private static double[] getElements(Matrix matrix) {
        int n;
        if (matrix.getNumRow() != 3 || matrix.getNumCol() != 3) {
            throw new IllegalArgumentException(Errors.format((int)85));
        }
        for (n = 0; n < 3; ++n) {
            AffineMatrix3.checkLastRow(n, matrix.getElement(2, n));
        }
        n = 0;
        double[] dArray = new double[6];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[n++] = matrix.getElement(i, j);
            }
        }
        assert (n == dArray.length) : n;
        return dArray;
    }

    private void setTransform(double[] dArray) {
        this.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    @Override
    public final int getNumRow() {
        return 3;
    }

    @Override
    public final int getNumCol() {
        return 3;
    }

    @Override
    public double getElement(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.getScaleX();
                    }
                    case 1: {
                        return this.getShearX();
                    }
                    case 2: {
                        return this.getTranslateX();
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.getShearY();
                    }
                    case 1: {
                        return this.getScaleY();
                    }
                    case 2: {
                        return this.getTranslateY();
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: 
                    case 1: {
                        return 0.0;
                    }
                    case 2: {
                        return 1.0;
                    }
                }
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"column", (Object)n2));
            }
        }
        throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"row", (Object)n));
    }

    @Override
    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= 3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"row", (Object)n));
        }
        if (n2 < 0 || n2 >= 3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"column", (Object)n2));
        }
        if (n == 2) {
            AffineMatrix3.checkLastRow(n2, d);
            return;
        }
        double[] dArray = new double[6];
        this.getMatrix(dArray);
        dArray[n * 3 + n2] = d;
        this.setTransform(dArray);
        assert (Double.compare(this.getElement(n, n2), d) == 0) : d;
    }

    private static void checkLastRow(int n, double d) throws IllegalArgumentException {
        if (d != (double)(n == 2 ? 1 : 0)) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)("matrix[2," + n + ']'), (Object)d));
        }
    }

    @Override
    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public AffineMatrix3 clone() {
        return (AffineMatrix3)super.clone();
    }
}

