/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class Krovak
extends UnitaryProjection {
    private static final long serialVersionUID = -8359105634355342212L;
    private static final double ITERATION_TOLERANCE = 1.0E-11;
    private final double sinAzim;
    private final double cosAzim;
    private final double n;
    private final double tanS2;
    private final double alfa;
    private final double hae;
    private final double k1;
    private final double ka;
    private final double ro0;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        Krovak krovak = new Krovak(parameters);
        return krovak.createConcatenatedTransform();
    }

    protected Krovak(UnitaryProjection.Parameters parameters) {
        super(parameters);
        double d;
        double d2 = parameters.latitudeOfOrigin;
        UnitaryProjection.Parameters.ensureLatitudeInRange(org.geotoolkit.referencing.operation.provider.Krovak.LATITUDE_OF_CENTRE, d2, false);
        d2 = Math.toRadians(d2);
        switch (parameters.standardParallels.length) {
            default: {
                throw Krovak.unknownParameter(UniversalParameters.STANDARD_PARALLEL_2);
            }
            case 0: {
                d = org.geotoolkit.referencing.operation.provider.Krovak.PSEUDO_STANDARD_PARALLEL.getDefaultValue();
                break;
            }
            case 1: {
                d = parameters.standardParallels[0];
            }
        }
        d = Math.toRadians(d);
        double d3 = Math.toRadians(parameters.azimuth);
        this.sinAzim = Math.sin(d3);
        this.cosAzim = Math.cos(d3);
        this.n = Math.sin(d);
        this.tanS2 = Math.tan(d / 2.0 + 0.7853981633974483);
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = d5 * d5;
        this.alfa = Math.sqrt(1.0 + this.excentricitySquared * (d6 * d6) / (1.0 - this.excentricitySquared));
        this.hae = this.alfa * this.excentricity / 2.0;
        double d7 = Math.asin(d4 / this.alfa);
        double d8 = this.excentricity * d4;
        double d9 = Math.pow((1.0 - d8) / (1.0 + d8), this.alfa * this.excentricity / 2.0);
        this.k1 = Math.pow(Math.tan(d2 / 2.0 + 0.7853981633974483), this.alfa) * d9 / Math.tan(d7 / 2.0 + 0.7853981633974483);
        this.ka = Math.pow(1.0 / this.k1, -1.0 / this.alfa);
        this.ro0 = Math.pow(this.tanS2, -this.n);
        double d10 = Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - this.excentricitySquared * (d4 * d4));
        double d11 = d10 / (this.ro0 * Math.tan(d));
        parameters.normalize(true).scale(-this.alfa, 1.0);
        parameters.validate();
        parameters.normalize(false).scale(-d11, -d11);
        this.finish();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double d5 = this.excentricity * Math.sin(d2);
        double d6 = Math.tan(d2 / 2.0 + 0.7853981633974483);
        double d7 = Math.pow((1.0 - d5) / (1.0 + d5), this.hae);
        double d8 = Math.pow(d6, this.alfa) / this.k1 * d7;
        double d9 = 2.0 * (Math.atan(d8) - 0.7853981633974483);
        double d10 = Math.sin(d9);
        double d11 = Math.cos(d9);
        double d12 = this.cosAzim * d10 + this.sinAzim * d11 * d4;
        double d13 = Math.sqrt(1.0 - d12 * d12);
        double d14 = Math.asin(d12);
        double d15 = d11 * d3 / d13;
        double d16 = this.n * Math.asin(d15);
        double d17 = Math.cos(d16);
        double d18 = Math.sin(d16);
        double d19 = Math.tan(d14 / 2.0 + 0.7853981633974483);
        double d20 = Math.pow(d19, this.n);
        if (dArray2 != null) {
            dArray2[n2] = d18 / d20;
            dArray2[n2 + 1] = d17 / d20;
        }
        if (!bl) {
            return null;
        }
        double d21 = this.excentricitySquared * Math.cos(d2) / (1.0 - d5 * d5);
        double d22 = this.alfa * (1.0 / d6 + d6 - 2.0 * d21) / (1.0 / d8 + d8);
        double d23 = -this.sinAzim * d11 * d3 / d13;
        double d24 = (-this.sinAzim * d10 * d4 + this.cosAzim * d11) * d22 / d13;
        double d25 = this.n / (d13 * d13 * Math.sqrt(1.0 - d15 * d15));
        double d26 = d11 * d25 * (d23 * d3 * d12 + d4 * d13);
        double d27 = d3 * d25 * (d24 * d12 * d11 - d22 * d10 * d13);
        double d28 = -this.n / 2.0 * (1.0 / d19 + d19);
        return new Matrix2((d28 * d23 * d18 + d26 * d17) / d20, (d28 * d24 * d18 + d27 * d17) / d20, (d28 * d23 * d17 - d26 * d18) / d20, (d28 * d24 * d17 - d27 * d18) / d20);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3 = dArray[n];
        double d4 = dArray[n + 1];
        double d5 = Math.hypot(d3, d4);
        double d6 = Math.atan2(d3, d4) / this.n;
        double d7 = 2.0 * (Math.atan(Math.pow(this.ro0 / d5, 1.0 / this.n) * this.tanS2) - 0.7853981633974483);
        double d8 = Math.cos(d7);
        double d9 = Math.asin(this.cosAzim * Math.sin(d7) - this.sinAzim * d8 * Math.cos(d6));
        double d10 = this.ka * Math.pow(Math.tan(d9 / 2.0 + 0.7853981633974483), 1.0 / this.alfa);
        double d11 = Math.asin(d8 * Math.sin(d6) / Math.cos(d9));
        double d12 = 0.0;
        int n3 = 15;
        while (!(Math.abs((d2 = d12) - (d12 = 2.0 * (Math.atan(d10 * Math.pow((1.0 + (d = this.excentricity * Math.sin(d2))) / (1.0 - d), this.excentricity / 2.0)) - 0.7853981633974483))) <= 1.0E-11)) {
            if (--n3 >= 0) continue;
            throw new ProjectionException(152);
        }
        dArray2[n2] = d11;
        dArray2[n2 + 1] = d12;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((double)this.sinAzim, (int)Utilities.hash((double)this.n, (int)super.computeHashCode()));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            Krovak krovak = (Krovak)object;
            return InternalUtilities.epsilonEqual((double)this.sinAzim, (double)krovak.sinAzim, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.cosAzim, (double)krovak.cosAzim, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.n, (double)krovak.n, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.tanS2, (double)krovak.tanS2, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.alfa, (double)krovak.alfa, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.hae, (double)krovak.hae, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.k1, (double)krovak.k1, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.ka, (double)krovak.ka, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.ro0, (double)krovak.ro0, (ComparisonMode)comparisonMode);
        }
        return false;
    }
}

